/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.source.dialect;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfig;
import org.apache.flink.cdc.connectors.base.dialect.JdbcDataSourceDialect;
import org.apache.flink.cdc.connectors.base.source.assigner.splitter.JdbcSourceChunkSplitter;
import org.apache.flink.cdc.connectors.base.source.assigner.state.ChunkSplitterState;
import org.apache.flink.cdc.connectors.sqlserver.source.utils.SqlServerTypeUtils;
import org.apache.flink.cdc.connectors.sqlserver.source.utils.SqlServerUtils;
import org.apache.flink.table.types.DataType;

@Internal
public class SqlServerChunkSplitter
extends JdbcSourceChunkSplitter {
    public SqlServerChunkSplitter(JdbcSourceConfig sourceConfig, JdbcDataSourceDialect dialect, ChunkSplitterState chunkSplitterState) {
        super(sourceConfig, dialect, chunkSplitterState);
    }

    protected DataType fromDbzColumn(Column splitColumn) {
        return SqlServerTypeUtils.fromDbzColumn(splitColumn);
    }

    protected Object queryNextChunkMax(JdbcConnection jdbc, TableId tableId, Column splitColumn, int chunkSize, Object includedLowerBound) throws SQLException {
        return SqlServerUtils.queryNextChunkMax(jdbc, tableId, splitColumn.name(), chunkSize, includedLowerBound);
    }

    protected Long queryApproximateRowCnt(JdbcConnection jdbc, TableId tableId) throws SQLException {
        return SqlServerUtils.queryApproximateRowCnt(jdbc, tableId);
    }

    protected boolean isChunkEndLeMax(JdbcConnection jdbc, Object chunkEnd, Object max, Column splitColumn) {
        return SqlServerUtils.compare(chunkEnd, max, splitColumn) <= 0;
    }

    protected boolean isChunkEndGeMax(JdbcConnection jdbc, Object chunkEnd, Object max, Column splitColumn) {
        return SqlServerUtils.compare(chunkEnd, max, splitColumn) >= 0;
    }
}

