/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.source.config;

import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnector;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfigFactory;
import org.apache.flink.cdc.connectors.base.source.EmbeddedFlinkDatabaseHistory;
import org.apache.flink.cdc.connectors.base.utils.EnvironmentUtils;
import org.apache.flink.cdc.connectors.sqlserver.source.config.SqlServerSourceConfig;
import org.apache.flink.util.Preconditions;

public class SqlServerSourceConfigFactory
extends JdbcSourceConfigFactory {
    private static final String DATABASE_SERVER_NAME = "sqlserver_transaction_log_source";
    private static final String DRIVER_ClASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    public SqlServerSourceConfig create(int subtask) {
        EnvironmentUtils.checkSupportCheckpointsAfterTasksFinished((boolean)this.closeIdleReaders);
        Properties props = new Properties();
        props.setProperty("connector.class", SqlServerConnector.class.getCanonicalName());
        props.setProperty("database.history", EmbeddedFlinkDatabaseHistory.class.getCanonicalName());
        props.setProperty("database.history.instance.name", UUID.randomUUID() + "_" + subtask);
        props.setProperty("database.server.name", DATABASE_SERVER_NAME);
        props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
        props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
        props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
        props.setProperty("database.port", String.valueOf(this.port));
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.dbname", (String)Preconditions.checkNotNull(this.databaseList.get(0)));
        if (this.tableList != null) {
            props.setProperty("table.include.list", String.join((CharSequence)",", this.tableList));
        }
        switch (this.startupOptions.startupMode) {
            case INITIAL: {
                props.setProperty("snapshot.mode", "initial");
                break;
            }
            case LATEST_OFFSET: {
                props.setProperty("snapshot.mode", "schema_only");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.dbzProperties != null) {
            props.putAll((Map<?, ?>)this.dbzProperties);
        }
        Configuration dbzConfiguration = Configuration.from((Properties)props);
        return new SqlServerSourceConfig(this.startupOptions, this.databaseList, this.tableList, this.splitSize, this.splitMetaGroupSize, this.distributionFactorUpper, this.distributionFactorLower, this.includeSchemaChanges, this.closeIdleReaders, props, dbzConfiguration, DRIVER_ClASS_NAME, this.hostname, this.port, this.username, this.password, this.fetchSize, this.serverTimeZone, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.chunkKeyColumn, this.skipSnapshotBackfill, this.assignUnboundedChunkFirst);
    }
}

