/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.Utils;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ServerInfo;
import io.debezium.time.Conversions;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import org.apache.flink.cdc.connectors.postgres.source.offset.PostgresOffset;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static PostgresOffset committedOffset(PostgresConnection jdbcConnection, String slotName, String pluginName) {
        Long txId;
        Long lsn;
        try {
            ServerInfo.ReplicationSlot slot = jdbcConnection.readReplicationSlotInfo(slotName, pluginName);
            if (slot == ServerInfo.ReplicationSlot.INVALID) {
                return Utils.currentOffset(jdbcConnection);
            }
            lsn = slot.latestFlushedLsn().asLong();
            txId = slot.catalogXmin();
            LOGGER.trace("Read xlogStart at '{}' from transaction '{}'", (Object)Lsn.valueOf(lsn), (Object)txId);
        }
        catch (InterruptedException | SQLException e) {
            throw new FlinkRuntimeException("Error getting current Lsn/txId " + e.getMessage(), (Throwable)e);
        }
        try {
            jdbcConnection.commit();
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("JDBC connection fails to commit: " + e.getMessage(), (Throwable)e);
        }
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put("lsn", lsn.toString());
        if (txId != null) {
            offsetMap.put("txId", txId.toString());
        }
        offsetMap.put("ts_usec", String.valueOf(Conversions.toEpochMicros((Instant)Instant.MIN)));
        return PostgresOffset.of(offsetMap);
    }
}

