/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.table;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.oceanbase.OceanBaseSource;
import org.apache.flink.cdc.connectors.oceanbase.source.converter.OceanBaseDeserializationConverterFactory;
import org.apache.flink.cdc.connectors.oceanbase.table.OceanBaseReadableMetadata;
import org.apache.flink.cdc.debezium.table.MetadataConverter;
import org.apache.flink.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class OceanBaseTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    private final StartupOptions startupOptions;
    private final String username;
    private final String password;
    private final String tenantName;
    private final String databaseName;
    private final String tableName;
    private final String tableList;
    private final Duration connectTimeout;
    private final String serverTimeZone;
    private final String hostname;
    private final int port;
    private final String compatibleMode;
    private final String jdbcDriver;
    private final Properties jdbcProperties;
    private final String logProxyHost;
    private final Integer logProxyPort;
    private final String logProxyClientId;
    private final Long startupTimestamp;
    private final String rsList;
    private final String configUrl;
    private final String workingMode;
    private final Properties obcdcProperties;
    private final Properties debeziumProperties;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public OceanBaseTableSource(ResolvedSchema physicalSchema, StartupOptions startupOptions, String username, String password, String tenantName, String databaseName, String tableName, String tableList, String serverTimeZone, Duration connectTimeout, String hostname, int port, String compatibleMode, String jdbcDriver, Properties jdbcProperties, String logProxyHost, Integer logProxyPort, String logProxyClientId, Long startupTimestamp, String rsList, String configUrl, String workingMode, Properties obcdcProperties, Properties debeziumProperties) {
        this.physicalSchema = physicalSchema;
        this.startupOptions = (StartupOptions)Preconditions.checkNotNull((Object)startupOptions);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.tenantName = tenantName;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.tableList = tableList;
        this.serverTimeZone = serverTimeZone;
        this.connectTimeout = connectTimeout;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.port = port;
        this.compatibleMode = compatibleMode;
        this.jdbcDriver = jdbcDriver;
        this.jdbcProperties = jdbcProperties;
        this.logProxyHost = logProxyHost;
        this.logProxyPort = logProxyPort;
        this.logProxyClientId = logProxyClientId;
        this.startupTimestamp = startupTimestamp;
        this.rsList = rsList;
        this.configUrl = configUrl;
        this.workingMode = workingMode;
        this.obcdcProperties = obcdcProperties;
        this.debeziumProperties = debeziumProperties;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.all();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation resultTypeInfo = context.createTypeInformation(this.producedDataType);
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setMetadataConverters(metadataConverters).setResultTypeInfo(resultTypeInfo).setServerTimeZone(this.serverTimeZone == null ? ZoneId.systemDefault() : ZoneId.of(this.serverTimeZone)).setUserDefinedConverterFactory(OceanBaseDeserializationConverterFactory.instance()).build();
        OceanBaseSource.Builder builder = OceanBaseSource.builder().startupOptions(this.startupOptions).username(this.username).password(this.password).tenantName(this.tenantName).databaseName(this.databaseName).tableName(this.tableName).tableList(this.tableList).serverTimeZone(this.serverTimeZone).connectTimeout(this.connectTimeout).hostname(this.hostname).port(this.port).compatibleMode(this.compatibleMode).jdbcDriver(this.jdbcDriver).jdbcProperties(this.jdbcProperties).logProxyHost(this.logProxyHost).logProxyPort(this.logProxyPort).logProxyClientId(this.logProxyClientId).startupTimestamp(this.startupTimestamp).rsList(this.rsList).configUrl(this.configUrl).workingMode(this.workingMode).obcdcProperties(this.obcdcProperties).debeziumProperties(this.debeziumProperties).deserializer(deserializer);
        return SourceFunctionProvider.of(builder.build(), (boolean)false);
    }

    protected MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(OceanBaseReadableMetadata.values()).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(OceanBaseReadableMetadata::getConverter).toArray(MetadataConverter[]::new);
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(OceanBaseReadableMetadata.values()).collect(Collectors.toMap(OceanBaseReadableMetadata::getKey, OceanBaseReadableMetadata::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }

    public DynamicTableSource copy() {
        OceanBaseTableSource source = new OceanBaseTableSource(this.physicalSchema, this.startupOptions, this.username, this.password, this.tenantName, this.databaseName, this.tableName, this.tableList, this.serverTimeZone, this.connectTimeout, this.hostname, this.port, this.compatibleMode, this.jdbcDriver, this.jdbcProperties, this.logProxyHost, this.logProxyPort, this.logProxyClientId, this.startupTimestamp, this.rsList, this.configUrl, this.workingMode, this.obcdcProperties, this.debeziumProperties);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OceanBaseTableSource that = (OceanBaseTableSource)o;
        return Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.startupOptions, that.startupOptions) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.tenantName, that.tenantName) && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.tableList, that.tableList) && Objects.equals(this.serverTimeZone, that.serverTimeZone) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.port, that.port) && Objects.equals(this.compatibleMode, that.compatibleMode) && Objects.equals(this.jdbcDriver, that.jdbcDriver) && Objects.equals(this.jdbcProperties, that.jdbcProperties) && Objects.equals(this.logProxyHost, that.logProxyHost) && Objects.equals(this.logProxyPort, that.logProxyPort) && Objects.equals(this.logProxyClientId, that.logProxyClientId) && Objects.equals(this.startupTimestamp, that.startupTimestamp) && Objects.equals(this.rsList, that.rsList) && Objects.equals(this.configUrl, that.configUrl) && Objects.equals(this.workingMode, that.workingMode) && Objects.equals(this.obcdcProperties, that.obcdcProperties) && Objects.equals(this.debeziumProperties, that.debeziumProperties) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.startupOptions, this.username, this.password, this.tenantName, this.databaseName, this.tableName, this.tableList, this.serverTimeZone, this.connectTimeout, this.hostname, this.port, this.compatibleMode, this.jdbcDriver, this.jdbcProperties, this.logProxyHost, this.logProxyPort, this.logProxyClientId, this.startupTimestamp, this.rsList, this.configUrl, this.workingMode, this.obcdcProperties, this.debeziumProperties, this.producedDataType, this.metadataKeys);
    }

    public String asSummaryString() {
        return "OceanBase-CDC";
    }
}

