/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.source.offset;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.oceanbase.source.config.OceanBaseConnectorConfig;

public class OceanBaseSourceInfo
extends BaseSourceInfo {
    public static final String TENANT_KEY = "tenant";
    public static final String TRANSACTION_ID_KEY = "transaction_id";
    private final String tenant;
    private Instant sourceTime;
    private Set<TableId> tableIds;
    private String transactionId;

    public OceanBaseSourceInfo(OceanBaseConnectorConfig config, String tenant) {
        super((CommonConnectorConfig)config);
        this.tenant = tenant;
    }

    public String tenant() {
        return this.tenant;
    }

    protected Instant timestamp() {
        return this.sourceTime;
    }

    public void setSourceTime(Instant sourceTime) {
        this.sourceTime = sourceTime;
    }

    public void beginTransaction(String transactionId) {
        this.transactionId = transactionId;
    }

    public void commitTransaction() {
        this.transactionId = null;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public void tableEvent(TableId tableId) {
        this.tableIds = Collections.singleton(tableId);
    }

    protected String database() {
        return this.tableIds != null ? this.tableIds.iterator().next().catalog() : null;
    }

    public String tableSchema() {
        return this.tableIds == null || this.tableIds.isEmpty() ? null : this.tableIds.stream().filter(Objects::nonNull).map(TableId::schema).filter(Objects::nonNull).distinct().collect(Collectors.joining(","));
    }

    public String table() {
        return this.tableIds == null || this.tableIds.isEmpty() ? null : this.tableIds.stream().filter(Objects::nonNull).map(TableId::table).collect(Collectors.joining(","));
    }
}

