/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.connection;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.util.FlinkRuntimeException;

public class PooledDataSourceFactory {
    public static final String JDBC_URL_PATTERN = "jdbc:mysql://%s:%s/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true";
    public static final String CONNECTION_POOL_PREFIX = "connection-pool-";
    public static final String SERVER_TIMEZONE_KEY = "serverTimezone";
    public static final int MINIMUM_POOL_SIZE = 1;
    private static final Properties DEFAULT_JDBC_PROPERTIES = PooledDataSourceFactory.initializeDefaultJdbcProperties();

    private PooledDataSourceFactory() {
    }

    public static HikariDataSource createPooledDataSource(MySqlSourceConfig sourceConfig) {
        HikariConfig config = new HikariConfig();
        String hostName = sourceConfig.getHostname();
        int port = sourceConfig.getPort();
        Properties jdbcProperties = sourceConfig.getJdbcProperties();
        config.setPoolName(CONNECTION_POOL_PREFIX + hostName + ":" + port);
        config.setJdbcUrl(PooledDataSourceFactory.formatJdbcUrl(hostName, port, jdbcProperties));
        config.setUsername(sourceConfig.getUsername());
        config.setPassword(sourceConfig.getPassword());
        config.setMinimumIdle(1);
        config.setMaximumPoolSize(sourceConfig.getConnectionPoolSize());
        config.setConnectionTimeout(sourceConfig.getConnectTimeout().toMillis());
        config.addDataSourceProperty(SERVER_TIMEZONE_KEY, (Object)sourceConfig.getServerTimeZone());
        DriverManager.getDrivers();
        config.setDriverClassName(sourceConfig.getDbzConfiguration().getString(MySqlConnectorConfig.JDBC_DRIVER));
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        try {
            return new HikariDataSource(config);
        }
        catch (HikariPool.PoolInitializationException e) {
            throw new FlinkRuntimeException("Initialize jdbc connection pool failed, this may caused by wrong jdbc configurations or unstable network. Please check your jdbc configurations and network.", (Throwable)e);
        }
    }

    private static String formatJdbcUrl(String hostName, int port, Properties jdbcProperties) {
        Properties combinedProperties = new Properties();
        combinedProperties.putAll((Map<?, ?>)DEFAULT_JDBC_PROPERTIES);
        combinedProperties.putAll((Map<?, ?>)jdbcProperties);
        StringBuilder jdbcUrlStringBuilder = new StringBuilder(String.format(JDBC_URL_PATTERN, hostName, port));
        combinedProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> jdbcUrlStringBuilder.append("&").append(key).append("=").append(value)));
        return jdbcUrlStringBuilder.toString();
    }

    private static Properties initializeDefaultJdbcProperties() {
        Properties defaultJdbcProperties = new Properties();
        defaultJdbcProperties.setProperty("zeroDateTimeBehavior", "CONVERT_TO_NULL");
        defaultJdbcProperties.setProperty("characterEncoding", "UTF-8");
        defaultJdbcProperties.setProperty("characterSetResults", "UTF-8");
        return defaultJdbcProperties;
    }
}

