/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.schema;

import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.SchemaChangeEvent;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.cdc.connectors.mysql.debezium.DebeziumUtils;
import org.apache.flink.cdc.connectors.mysql.schema.MySqlFieldDefinition;
import org.apache.flink.cdc.connectors.mysql.schema.MySqlTableDefinition;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.utils.StatementUtils;
import org.apache.flink.util.FlinkRuntimeException;

public class MySqlSchema
implements AutoCloseable {
    private static final String SHOW_CREATE_TABLE = "SHOW CREATE TABLE ";
    private static final String DESC_TABLE = "DESC ";
    private final MySqlConnectorConfig connectorConfig;
    private final MySqlDatabaseSchema databaseSchema;
    private final Map<TableId, TableChanges.TableChange> schemasByTableId;

    public MySqlSchema(MySqlSourceConfig sourceConfig, boolean isTableIdCaseSensitive) {
        this.connectorConfig = sourceConfig.getMySqlConnectorConfig();
        this.databaseSchema = DebeziumUtils.createMySqlDatabaseSchema(this.connectorConfig, isTableIdCaseSensitive);
        this.schemasByTableId = new HashMap<TableId, TableChanges.TableChange>();
    }

    public TableChanges.TableChange getTableSchema(MySqlPartition partition, JdbcConnection jdbc, TableId tableId) {
        TableChanges.TableChange schema = this.schemasByTableId.get(tableId);
        if (schema == null) {
            schema = this.buildTableSchema(partition, jdbc, tableId);
            this.schemasByTableId.put(tableId, schema);
        }
        return schema;
    }

    private TableChanges.TableChange buildTableSchema(MySqlPartition partition, JdbcConnection jdbc, TableId tableId) {
        HashMap<TableId, TableChanges.TableChange> tableChangeMap = new HashMap<TableId, TableChanges.TableChange>();
        String showCreateTable = SHOW_CREATE_TABLE + StatementUtils.quote(tableId);
        this.buildSchemaByShowCreateTable(partition, jdbc, tableId, tableChangeMap);
        if (!tableChangeMap.containsKey(tableId)) {
            String descTable = DESC_TABLE + StatementUtils.quote(tableId);
            this.buildSchemaByDescTable(partition, jdbc, descTable, tableId, tableChangeMap);
            if (!tableChangeMap.containsKey(tableId)) {
                throw new FlinkRuntimeException(String.format("Can't obtain schema for table %s by running %s and %s ", tableId, showCreateTable, descTable));
            }
        }
        return (TableChanges.TableChange)tableChangeMap.get(tableId);
    }

    private void buildSchemaByShowCreateTable(MySqlPartition partition, JdbcConnection jdbc, TableId tableId, Map<TableId, TableChanges.TableChange> tableChangeMap) {
        String sql = SHOW_CREATE_TABLE + StatementUtils.quote(tableId);
        try {
            jdbc.query(sql, rs -> {
                if (rs.next()) {
                    String ddl = rs.getString(2);
                    this.parseSchemaByDdl(partition, ddl, tableId, tableChangeMap);
                }
            });
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException(String.format("Failed to read schema for table %s by running %s", tableId, sql), (Throwable)e);
        }
    }

    private void parseSchemaByDdl(MySqlPartition partition, String ddl, TableId tableId, Map<TableId, TableChanges.TableChange> tableChangeMap) {
        MySqlOffsetContext offsetContext = MySqlOffsetContext.initial((MySqlConnectorConfig)this.connectorConfig);
        List schemaChangeEvents = this.databaseSchema.parseSnapshotDdl(partition, ddl, tableId.catalog(), offsetContext, Instant.now());
        for (SchemaChangeEvent schemaChangeEvent : schemaChangeEvents) {
            for (TableChanges.TableChange tableChange : schemaChangeEvent.getTableChanges()) {
                tableChangeMap.put(tableId, tableChange);
            }
        }
    }

    private void buildSchemaByDescTable(MySqlPartition partition, JdbcConnection jdbc, String descTable, TableId tableId, Map<TableId, TableChanges.TableChange> tableChangeMap) {
        ArrayList<MySqlFieldDefinition> fieldMetas = new ArrayList<MySqlFieldDefinition>();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try {
            jdbc.query(descTable, rs -> {
                while (rs.next()) {
                    MySqlFieldDefinition meta = new MySqlFieldDefinition();
                    meta.setColumnName(rs.getString("Field"));
                    meta.setColumnType(rs.getString("Type"));
                    meta.setNullable(StringUtils.equalsIgnoreCase((CharSequence)rs.getString("Null"), (CharSequence)"YES"));
                    meta.setKey("PRI".equalsIgnoreCase(rs.getString("Key")));
                    meta.setUnique("UNI".equalsIgnoreCase(rs.getString("Key")));
                    meta.setDefaultValue(rs.getString("Default"));
                    meta.setExtra(rs.getString("Extra"));
                    if (meta.isKey()) {
                        primaryKeys.add(meta.getColumnName());
                    }
                    fieldMetas.add(meta);
                }
            });
            this.parseSchemaByDdl(partition, new MySqlTableDefinition(tableId, fieldMetas, primaryKeys).toDdl(), tableId, tableChangeMap);
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException(String.format("Failed to read schema for table %s by running %s", tableId, descTable), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.databaseSchema.close();
    }
}

