/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.debezium.task.context;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.relational.TableId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.cdc.connectors.mysql.debezium.task.context.exception.SchemaOutOfSyncException;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlErrorHandler
extends ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlErrorHandler.class);
    private static final Pattern NOT_FOUND_TABLE_MSG_PATTERN = Pattern.compile("Encountered change event for table (.+)\\.(.+) whose schema isn't known to this connector");
    private final MySqlTaskContext context;
    private final MySqlSourceConfig sourceConfig;

    public MySqlErrorHandler(MySqlConnectorConfig mySqlConnectorConfig, ChangeEventQueue<?> queue, MySqlTaskContext context, MySqlSourceConfig sourceConfig) {
        super(MySqlConnector.class, (CommonConnectorConfig)mySqlConnectorConfig, queue);
        this.context = context;
        this.sourceConfig = sourceConfig;
    }

    public void setProducerThrowable(Throwable producerThrowable) {
        if (this.isTableNotFoundException(producerThrowable)) {
            Matcher matcher = NOT_FOUND_TABLE_MSG_PATTERN.matcher(producerThrowable.getCause().getMessage());
            String databaseName = matcher.group(1);
            String tableName = matcher.group(2);
            TableId tableId = new TableId(databaseName, null, tableName);
            if (this.context.getSchema().schemaFor(tableId) == null) {
                LOG.warn("Schema for table " + tableId + " is null");
                return;
            }
        }
        if (this.isSchemaOutOfSyncException(producerThrowable)) {
            super.setProducerThrowable((Throwable)new SchemaOutOfSyncException("Internal schema representation is probably out of sync with real database schema. The reason could be that the table schema was changed after the starting binlog offset, which is not supported when startup mode is set to " + (Object)((Object)this.sourceConfig.getStartupOptions().startupMode), producerThrowable));
            return;
        }
        super.setProducerThrowable(producerThrowable);
    }

    private boolean isTableNotFoundException(Throwable t) {
        if (!(t.getCause() instanceof DebeziumException)) {
            return false;
        }
        DebeziumException e = (DebeziumException)t.getCause();
        String detailMessage = e.getMessage();
        Matcher matcher = NOT_FOUND_TABLE_MSG_PATTERN.matcher(detailMessage);
        return matcher.find();
    }

    private boolean isSchemaOutOfSyncException(Throwable t) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
        return rootCause instanceof ConnectException && rootCause.getMessage().endsWith("internal schema representation is probably out of sync with real database schema") && this.sourceConfig.getStartupOptions().isStreamOnly();
    }
}

