/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.table;

import org.apache.flink.cdc.debezium.table.MetadataConverter;
import org.apache.flink.cdc.debezium.table.RowDataMetadataConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public enum MongoDBReadableMetadata {
    COLLECTION("collection_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct to = value.getStruct("ns");
            return StringData.fromString((String)to.getString("coll"));
        }
    }),
    DATABASE("database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct to = value.getStruct("ns");
            return StringData.fromString((String)to.getString("db"));
        }
    }),
    OP_TS("op_ts", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct source = value.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)source.get("ts_ms")));
        }
    }),
    ROW_KIND("row_kind", (DataType)DataTypes.STRING().notNull(), (MetadataConverter)new RowDataMetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(RowData rowData) {
            return StringData.fromString((String)rowData.getRowKind().shortString());
        }

        public Object read(SourceRecord record) {
            throw new UnsupportedOperationException("Please call read(RowData rowData) method instead.");
        }
    });

    private final String key;
    private final DataType dataType;
    private final MetadataConverter converter;

    private MongoDBReadableMetadata(String key, DataType dataType, MetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MetadataConverter getConverter() {
        return this.converter;
    }
}

