/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source;

import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.dialect.DataSourceDialect;
import org.apache.flink.cdc.connectors.base.source.IncrementalSource;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceRecords;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitState;
import org.apache.flink.cdc.connectors.base.source.metrics.SourceReaderMetrics;
import org.apache.flink.cdc.connectors.mongodb.source.MongoDBSourceBuilder;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceConfigFactory;
import org.apache.flink.cdc.connectors.mongodb.source.dialect.MongoDBDialect;
import org.apache.flink.cdc.connectors.mongodb.source.offset.ChangeStreamOffsetFactory;
import org.apache.flink.cdc.connectors.mongodb.source.reader.MongoDBRecordEmitter;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.connector.base.source.reader.RecordEmitter;

@Experimental
@Internal
public class MongoDBSource<T>
extends IncrementalSource<T, MongoDBSourceConfig> {
    private static final long serialVersionUID = 1L;

    MongoDBSource(MongoDBSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema) {
        super((SourceConfig.Factory)configFactory, deserializationSchema, (OffsetFactory)new ChangeStreamOffsetFactory(), (DataSourceDialect)new MongoDBDialect());
    }

    @PublicEvolving
    public static <T> MongoDBSourceBuilder<T> builder() {
        return new MongoDBSourceBuilder();
    }

    protected RecordEmitter<SourceRecords, T, SourceSplitState> createRecordEmitter(SourceConfig sourceConfig, SourceReaderMetrics sourceReaderMetrics) {
        return new MongoDBRecordEmitter(this.deserializationSchema, sourceReaderMetrics, this.offsetFactory);
    }
}

