/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.config;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.mongodb.source.utils.MongoUtils;
import org.apache.flink.util.Preconditions;

public class MongoDBSourceConfig
implements SourceConfig {
    private static final long serialVersionUID = 1L;
    private final String scheme;
    private final String hosts;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final List<String> databaseList;
    @Nullable
    private final List<String> collectionList;
    private final String connectionString;
    private final int batchSize;
    private final int pollAwaitTimeMillis;
    private final int pollMaxBatchSize;
    private final boolean updateLookup;
    private final StartupOptions startupOptions;
    private final int heartbeatIntervalMillis;
    private final int splitMetaGroupSize;
    private final int splitSizeMB;
    private final int samplesPerChunk;
    private final boolean closeIdleReaders;
    private final boolean enableFullDocPrePostImage;
    private final boolean disableCursorTimeout;
    private final boolean skipSnapshotBackfill;
    private final boolean isScanNewlyAddedTableEnabled;

    MongoDBSourceConfig(String scheme, String hosts, @Nullable String username, @Nullable String password, @Nullable List<String> databaseList, @Nullable List<String> collectionList, @Nullable String connectionOptions, int batchSize, int pollAwaitTimeMillis, int pollMaxBatchSize, boolean updateLookup, StartupOptions startupOptions, int heartbeatIntervalMillis, int splitMetaGroupSize, int splitSizeMB, int samplesPerChunk, boolean closeIdleReaders, boolean enableFullDocPrePostImage, boolean disableCursorTimeout, boolean skipSnapshotBackfill, boolean isScanNewlyAddedTableEnabled) {
        this.scheme = (String)Preconditions.checkNotNull((Object)scheme);
        this.hosts = (String)Preconditions.checkNotNull((Object)hosts);
        this.username = username;
        this.password = password;
        this.databaseList = databaseList;
        this.collectionList = collectionList;
        this.connectionString = MongoUtils.buildConnectionString(username, password, scheme, hosts, connectionOptions);
        this.batchSize = batchSize;
        this.pollAwaitTimeMillis = pollAwaitTimeMillis;
        this.pollMaxBatchSize = pollMaxBatchSize;
        this.updateLookup = updateLookup;
        this.startupOptions = startupOptions;
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.splitSizeMB = splitSizeMB;
        this.samplesPerChunk = samplesPerChunk;
        this.closeIdleReaders = closeIdleReaders;
        this.enableFullDocPrePostImage = enableFullDocPrePostImage;
        this.disableCursorTimeout = disableCursorTimeout;
        this.skipSnapshotBackfill = skipSnapshotBackfill;
        this.isScanNewlyAddedTableEnabled = isScanNewlyAddedTableEnabled;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public List<String> getDatabaseList() {
        return this.databaseList;
    }

    @Nullable
    public List<String> getCollectionList() {
        return this.collectionList;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getPollAwaitTimeMillis() {
        return this.pollAwaitTimeMillis;
    }

    public int getPollMaxBatchSize() {
        return this.pollMaxBatchSize;
    }

    public int getHeartbeatIntervalMillis() {
        return this.heartbeatIntervalMillis;
    }

    public boolean isUpdateLookup() {
        return this.updateLookup;
    }

    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    public int getSplitSize() {
        return this.splitSizeMB;
    }

    public int getSplitMetaGroupSize() {
        return this.splitMetaGroupSize;
    }

    public int getSamplesPerChunk() {
        return this.samplesPerChunk;
    }

    public boolean isIncludeSchemaChanges() {
        return false;
    }

    public boolean isCloseIdleReaders() {
        return this.closeIdleReaders;
    }

    public boolean isFullDocPrePostImageEnabled() {
        return this.enableFullDocPrePostImage;
    }

    public boolean disableCursorTimeout() {
        return this.disableCursorTimeout;
    }

    public boolean isSkipSnapshotBackfill() {
        return this.skipSnapshotBackfill;
    }

    public boolean isScanNewlyAddedTableEnabled() {
        return this.isScanNewlyAddedTableEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDBSourceConfig that = (MongoDBSourceConfig)o;
        return this.batchSize == that.batchSize && this.pollAwaitTimeMillis == that.pollAwaitTimeMillis && this.pollMaxBatchSize == that.pollMaxBatchSize && this.updateLookup == that.updateLookup && this.startupOptions == that.startupOptions && this.heartbeatIntervalMillis == that.heartbeatIntervalMillis && this.splitMetaGroupSize == that.splitMetaGroupSize && this.splitSizeMB == that.splitSizeMB && this.samplesPerChunk == that.samplesPerChunk && this.closeIdleReaders == that.closeIdleReaders && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.hosts, that.hosts) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.databaseList, that.databaseList) && Objects.equals(this.collectionList, that.collectionList) && Objects.equals(this.connectionString, that.connectionString) && Objects.equals(this.skipSnapshotBackfill, that.skipSnapshotBackfill) && Objects.equals(this.isScanNewlyAddedTableEnabled, that.isScanNewlyAddedTableEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.hosts, this.username, this.password, this.databaseList, this.collectionList, this.connectionString, this.batchSize, this.pollAwaitTimeMillis, this.pollMaxBatchSize, this.updateLookup, this.startupOptions, this.heartbeatIntervalMillis, this.splitMetaGroupSize, this.splitSizeMB, this.samplesPerChunk, this.closeIdleReaders, this.skipSnapshotBackfill, this.isScanNewlyAddedTableEnabled);
    }
}

