/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.source.dialect;

import io.debezium.connector.db2.Db2Connection;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.util.FlinkRuntimeException;

public class Db2Schema {
    private final Map<TableId, TableChanges.TableChange> schemasByTableId = new ConcurrentHashMap<TableId, TableChanges.TableChange>();

    public TableChanges.TableChange getTableSchema(JdbcConnection jdbc, TableId tableId, Tables.TableFilter tableFilters) {
        TableChanges.TableChange schema = this.schemasByTableId.get(tableId);
        if (schema == null) {
            schema = this.readTableSchema(jdbc, tableId, tableFilters);
            this.schemasByTableId.put(tableId, schema);
        }
        return schema;
    }

    private TableChanges.TableChange readTableSchema(JdbcConnection jdbc, TableId tableId, Tables.TableFilter tableFilters) {
        Db2Connection db2Connection = (Db2Connection)jdbc;
        HashMap<TableId, TableChanges.TableChange> tableChangeMap = new HashMap<TableId, TableChanges.TableChange>();
        Tables tables = new Tables();
        tables.overwriteTable(tables.editOrCreateTable(tableId).create());
        try {
            db2Connection.readSchema(tables, null, tableId.schema(), tableFilters, null, false);
            Table table = tables.forTable(tableId);
            TableChanges.TableChange tableChange = new TableChanges.TableChange(TableChanges.TableChangeType.CREATE, table);
            tableChangeMap.put(tableId, tableChange);
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException(String.format("Failed to read schema for table %s ", tableId), (Throwable)e);
        }
        if (!tableChangeMap.containsKey(tableId)) {
            throw new FlinkRuntimeException(String.format("Can't obtain schema for table %s ", tableId));
        }
        return (TableChanges.TableChange)tableChangeMap.get(tableId);
    }
}

