/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.executors;

import java.net.MalformedURLException;
import java.time.Duration;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslationUtil;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.cli.ExecutionConfigAccessor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.core.execution.JobStatusChangedEvent;
import org.apache.flink.core.execution.JobStatusChangedListener;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.runtime.execution.DefaultJobCreatedEvent;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineExecutorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineExecutorUtils.class);

    public static JobGraph getJobGraph(@Nonnull Pipeline pipeline, @Nonnull Configuration configuration, @Nonnull ClassLoader userClassloader) throws MalformedURLException {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkNotNull((Object)configuration);
        ExecutionConfigAccessor executionConfigAccessor = ExecutionConfigAccessor.fromConfiguration(configuration);
        JobGraph jobGraph = FlinkPipelineTranslationUtil.getJobGraph(userClassloader, pipeline, configuration, executionConfigAccessor.getParallelism());
        configuration.getOptional(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID).ifPresent(strJobID -> jobGraph.setJobID(JobID.fromHexString((String)strJobID)));
        if (((Boolean)configuration.get(DeploymentOptions.ATTACHED)).booleanValue() && ((Boolean)configuration.get(DeploymentOptions.SHUTDOWN_IF_ATTACHED)).booleanValue()) {
            jobGraph.setInitialClientHeartbeatTimeout(((Duration)configuration.get(ClientOptions.CLIENT_HEARTBEAT_TIMEOUT)).toMillis());
        }
        jobGraph.addJars(executionConfigAccessor.getJars());
        jobGraph.setClasspaths(executionConfigAccessor.getClasspaths());
        jobGraph.setSavepointRestoreSettings(executionConfigAccessor.getSavepointRestoreSettings());
        return jobGraph;
    }

    public static void notifyJobStatusListeners(@Nonnull Pipeline pipeline, @Nonnull ExecutionPlan executionPlan, List<JobStatusChangedListener> listeners) {
        RuntimeExecutionMode executionMode = (RuntimeExecutionMode)executionPlan.getJobConfiguration().get(ExecutionOptions.RUNTIME_MODE);
        listeners.forEach(listener -> {
            try {
                listener.onEvent((JobStatusChangedEvent)new DefaultJobCreatedEvent(executionPlan.getJobID(), executionPlan.getName(), ((StreamGraph)pipeline).getLineageGraph(), executionMode));
            }
            catch (Throwable e) {
                LOG.error("Fail to notify job status changed listener {}", (Object)listener.getClass().getName(), (Object)e);
            }
        });
    }

    public static StreamGraph getStreamGraph(@Nonnull Pipeline pipeline, @Nonnull Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkState((boolean)(pipeline instanceof StreamGraph));
        StreamGraph streamGraph = (StreamGraph)pipeline;
        ExecutionConfigAccessor executionConfigAccessor = ExecutionConfigAccessor.fromConfiguration(configuration);
        configuration.getOptional(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID).ifPresent(strJobID -> streamGraph.setJobId(JobID.fromHexString((String)strJobID)));
        if (((Boolean)configuration.get(DeploymentOptions.ATTACHED)).booleanValue() && ((Boolean)configuration.get(DeploymentOptions.SHUTDOWN_IF_ATTACHED)).booleanValue()) {
            streamGraph.setInitialClientHeartbeatTimeout(((Duration)configuration.get(ClientOptions.CLIENT_HEARTBEAT_TIMEOUT)).toMillis());
        }
        streamGraph.addJars(executionConfigAccessor.getJars());
        streamGraph.setClasspath(executionConfigAccessor.getClasspaths());
        streamGraph.setSavepointRestoreSettings(executionConfigAccessor.getSavepointRestoreSettings());
        return streamGraph;
    }
}

