/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application.executors;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.application.WebSubmissionJobClient;
import org.apache.flink.client.deployment.application.executors.EmbeddedExecutor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.util.Preconditions;

@Internal
public class WebSubmissionExecutorFactory
implements PipelineExecutorFactory {
    private final Collection<JobID> submittedJobIds;
    private final DispatcherGateway dispatcherGateway;

    public WebSubmissionExecutorFactory(Collection<JobID> submittedJobIds, DispatcherGateway dispatcherGateway) {
        this.submittedJobIds = (Collection)Preconditions.checkNotNull(submittedJobIds);
        this.dispatcherGateway = (DispatcherGateway)Preconditions.checkNotNull((Object)dispatcherGateway);
    }

    public String getName() {
        return "embedded";
    }

    public boolean isCompatibleWith(Configuration configuration) {
        return false;
    }

    public PipelineExecutor getExecutor(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return new EmbeddedExecutor(this.submittedJobIds, this.dispatcherGateway, configuration, (jobId, userCodeClassloader) -> new WebSubmissionJobClient(jobId));
    }
}

