/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterRetrieveException;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.program.ClusterClientProvider;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class StandaloneClusterDescriptor
implements ClusterDescriptor<StandaloneClusterId> {
    private final Configuration config;

    public StandaloneClusterDescriptor(Configuration config) {
        this.config = (Configuration)Preconditions.checkNotNull((Object)config);
    }

    @Override
    public String getClusterDescription() {
        String host = (String)this.config.get(JobManagerOptions.ADDRESS, (Object)"");
        int port = (Integer)this.config.get(JobManagerOptions.PORT, (Object)-1);
        return "Standalone cluster at " + host + ":" + port;
    }

    @Override
    public ClusterClientProvider<StandaloneClusterId> retrieve(StandaloneClusterId standaloneClusterId) throws ClusterRetrieveException {
        return () -> {
            try {
                return new RestClusterClient<StandaloneClusterId>(this.config, standaloneClusterId);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't retrieve standalone cluster", e);
            }
        };
    }

    @Override
    public ClusterClientProvider<StandaloneClusterId> deploySessionCluster(ClusterSpecification clusterSpecification) {
        throw new UnsupportedOperationException("Can't deploy a standalone cluster.");
    }

    @Override
    public ClusterClientProvider<StandaloneClusterId> deployApplicationCluster(ClusterSpecification clusterSpecification, ApplicationConfiguration applicationConfiguration) {
        throw new UnsupportedOperationException("Application Mode not supported by standalone deployments.");
    }

    @Override
    public void killCluster(StandaloneClusterId clusterId) throws FlinkException {
        throw new UnsupportedOperationException("Cannot terminate a standalone cluster.");
    }

    @Override
    public void close() {
    }
}

