/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

public final class ClusterSpecification {
    private final int masterMemoryMB;
    private final int taskManagerMemoryMB;
    private final int slotsPerTaskManager;

    private ClusterSpecification(int masterMemoryMB, int taskManagerMemoryMB, int slotsPerTaskManager) {
        this.masterMemoryMB = masterMemoryMB;
        this.taskManagerMemoryMB = taskManagerMemoryMB;
        this.slotsPerTaskManager = slotsPerTaskManager;
    }

    public int getMasterMemoryMB() {
        return this.masterMemoryMB;
    }

    public int getTaskManagerMemoryMB() {
        return this.taskManagerMemoryMB;
    }

    public int getSlotsPerTaskManager() {
        return this.slotsPerTaskManager;
    }

    public String toString() {
        return "ClusterSpecification{masterMemoryMB=" + this.masterMemoryMB + ", taskManagerMemoryMB=" + this.taskManagerMemoryMB + ", slotsPerTaskManager=" + this.slotsPerTaskManager + "}";
    }

    public static class ClusterSpecificationBuilder {
        private int masterMemoryMB = 768;
        private int taskManagerMemoryMB = 1024;
        private int slotsPerTaskManager = 1;

        public ClusterSpecificationBuilder setMasterMemoryMB(int masterMemoryMB) {
            this.masterMemoryMB = masterMemoryMB;
            return this;
        }

        public ClusterSpecificationBuilder setTaskManagerMemoryMB(int taskManagerMemoryMB) {
            this.taskManagerMemoryMB = taskManagerMemoryMB;
            return this;
        }

        public ClusterSpecificationBuilder setSlotsPerTaskManager(int slotsPerTaskManager) {
            this.slotsPerTaskManager = slotsPerTaskManager;
            return this;
        }

        public ClusterSpecification createClusterSpecification() {
            return new ClusterSpecification(this.masterMemoryMB, this.taskManagerMemoryMB, this.slotsPerTaskManager);
        }
    }
}

