/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.executors;

import java.net.MalformedURLException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.deployment.executors.PipelineExecutorUtils;
import org.apache.flink.client.program.PerJobMiniClusterFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.JobStatusChangedListener;
import org.apache.flink.core.execution.JobStatusChangedListenerUtils;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class LocalExecutor
implements PipelineExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(LocalExecutor.class);
    private final ExecutorService executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("Flink-LocalExecutor-IO"));
    public static final String NAME = "local";
    private final Configuration configuration;
    private final Function<MiniClusterConfiguration, MiniCluster> miniClusterFactory;
    private final List<JobStatusChangedListener> jobStatusChangedListeners;

    public static LocalExecutor create(Configuration configuration) {
        return new LocalExecutor(configuration, MiniCluster::new);
    }

    public static LocalExecutor createWithFactory(Configuration configuration, Function<MiniClusterConfiguration, MiniCluster> miniClusterFactory) {
        return new LocalExecutor(configuration, miniClusterFactory);
    }

    private LocalExecutor(Configuration configuration, Function<MiniClusterConfiguration, MiniCluster> miniClusterFactory) {
        this.configuration = configuration;
        this.miniClusterFactory = miniClusterFactory;
        this.jobStatusChangedListeners = JobStatusChangedListenerUtils.createJobStatusChangedListeners((ClassLoader)Thread.currentThread().getContextClassLoader(), (Configuration)configuration, (Executor)this.executorService);
    }

    public CompletableFuture<JobClient> execute(Pipeline pipeline, Configuration configuration, ClassLoader userCodeClassloader) throws Exception {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkNotNull((Object)configuration);
        Configuration effectiveConfig = new Configuration();
        effectiveConfig.addAll(this.configuration);
        effectiveConfig.addAll(configuration);
        Preconditions.checkState((boolean)((Boolean)configuration.get(DeploymentOptions.ATTACHED)));
        JobGraph jobGraph = this.getJobGraph(pipeline, effectiveConfig, userCodeClassloader);
        return PerJobMiniClusterFactory.createWithFactory(effectiveConfig, this.miniClusterFactory).submitJob(jobGraph, userCodeClassloader).whenComplete((ignored, throwable) -> {
            if (throwable == null) {
                PipelineExecutorUtils.notifyJobStatusListeners(pipeline, jobGraph, this.jobStatusChangedListeners);
            } else {
                LOG.error("Failed to submit job graph to local mini cluster.", throwable);
            }
        });
    }

    private JobGraph getJobGraph(Pipeline pipeline, Configuration configuration, ClassLoader userCodeClassloader) throws MalformedURLException {
        if (pipeline instanceof Plan) {
            Plan plan = (Plan)pipeline;
            int slotsPerTaskManager = (Integer)configuration.get(TaskManagerOptions.NUM_TASK_SLOTS, (Object)plan.getMaximumParallelism());
            int numTaskManagers = (Integer)configuration.get(TaskManagerOptions.MINI_CLUSTER_NUM_TASK_MANAGERS);
            plan.setDefaultParallelism(slotsPerTaskManager * numTaskManagers);
        }
        return PipelineExecutorUtils.getJobGraph(pipeline, configuration, userCodeClassloader);
    }
}

