/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.artifact;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.client.cli.ArtifactFetchOptions;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.artifact.ArtifactFetcher;
import org.apache.flink.client.program.artifact.FsArtifactFetcher;
import org.apache.flink.client.program.artifact.HttpArtifactFetcher;
import org.apache.flink.client.program.artifact.LocalArtifactFetcher;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionUtils;

public class ArtifactFetchManager {
    private final ArtifactFetcher localFetcher;
    private final ArtifactFetcher fsFetcher;
    private final ArtifactFetcher httpFetcher;
    private final Configuration conf;
    private final File baseDir;

    public ArtifactFetchManager(Configuration conf) {
        this(conf, null);
    }

    public ArtifactFetchManager(Configuration conf, @Nullable String baseDir) {
        this(new LocalArtifactFetcher(), new FsArtifactFetcher(), new HttpArtifactFetcher(), conf, baseDir);
    }

    @VisibleForTesting
    ArtifactFetchManager(ArtifactFetcher localFetcher, ArtifactFetcher fsFetcher, ArtifactFetcher httpFetcher, Configuration conf, @Nullable String baseDir) {
        this.localFetcher = (ArtifactFetcher)Preconditions.checkNotNull((Object)localFetcher);
        this.fsFetcher = (ArtifactFetcher)Preconditions.checkNotNull((Object)fsFetcher);
        this.httpFetcher = (ArtifactFetcher)Preconditions.checkNotNull((Object)httpFetcher);
        this.conf = (Configuration)Preconditions.checkNotNull((Object)conf);
        this.baseDir = baseDir == null ? new File((String)conf.get(ArtifactFetchOptions.BASE_DIR)) : new File(baseDir);
    }

    public Result fetchArtifacts(String[] uris) {
        Preconditions.checkArgument((uris != null && uris.length > 0 ? 1 : 0) != 0, (Object)"At least one URI is required.");
        List artifacts = Arrays.stream(uris).map(FunctionUtils.uncheckedFunction(this::fetchArtifact)).collect(Collectors.toList());
        if (artifacts.size() > 1) {
            return new Result(null, artifacts);
        }
        if (artifacts.size() == 1) {
            return new Result((File)artifacts.get(0), null);
        }
        throw new IllegalStateException("Corrupt artifact fetching state.");
    }

    public Result fetchArtifacts(String jobUri, @Nullable List<String> additionalUris) throws Exception {
        Preconditions.checkArgument((jobUri != null && !jobUri.trim().isEmpty() ? 1 : 0) != 0, (Object)"The jobUri is required.");
        File jobJar = this.fetchArtifact(jobUri);
        List additionalArtifacts = additionalUris == null ? Collections.emptyList() : additionalUris.stream().map(FunctionUtils.uncheckedFunction(this::fetchArtifact)).collect(Collectors.toList());
        return new Result(jobJar, additionalArtifacts);
    }

    @VisibleForTesting
    ArtifactFetcher getFetcher(URI uri) {
        if ("local".equals(uri.getScheme())) {
            return this.localFetcher;
        }
        if (this.isRawHttp(uri.getScheme()) || "https".equals(uri.getScheme())) {
            return this.httpFetcher;
        }
        return this.fsFetcher;
    }

    private File fetchArtifact(String uri) throws Exception {
        URI resolvedUri = PackagedProgramUtils.resolveURI(uri);
        File targetFile = new File(this.baseDir, FilenameUtils.getName((String)resolvedUri.getPath()));
        if (targetFile.exists()) {
            return targetFile;
        }
        return this.getFetcher(resolvedUri).fetch(uri, this.conf, this.baseDir);
    }

    private boolean isRawHttp(String uriScheme) {
        if ("http".equals(uriScheme)) {
            if (this.conf.getBoolean(ArtifactFetchOptions.RAW_HTTP_ENABLED)) {
                return true;
            }
            throw new IllegalArgumentException(String.format("Artifact fetching from raw HTTP endpoints are disabled. Set the '%s' property to override.", ArtifactFetchOptions.RAW_HTTP_ENABLED.key()));
        }
        return false;
    }

    public static class Result {
        private final File jobJar;
        private final List<File> artifacts;

        private Result(@Nullable File jobJar, @Nullable List<File> additionalJars) {
            this.jobJar = jobJar;
            this.artifacts = additionalJars == null ? Collections.emptyList() : additionalJars;
        }

        @Nullable
        public File getJobJar() {
            return this.jobJar;
        }

        @Nullable
        public List<File> getArtifacts() {
            return this.artifacts.isEmpty() ? null : Collections.unmodifiableList(this.artifacts);
        }
    }
}

