/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.tools.ci.utils.shade;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.tools.ci.utils.shared.Dependency;
import org.apache.flink.tools.ci.utils.shared.ParserUtils;

public final class ShadeParser {
    private static final Pattern SHADE_NEXT_MODULE_PATTERN = Pattern.compile(".*:shade \\((?:shade-flink|shade-dist|default)\\) @ (?<module>[^ _]+)(?:_[0-9.]+)? --.*");
    private static final Pattern SHADE_INCLUDE_MODULE_PATTERN = Pattern.compile(".* (?<groupId>.*?):(?<artifactId>.*?):(?<type>.*?):(?:(?<classifier>.*?):)?(?<version>.*?) in the shaded jar");

    public static Map<String, Set<Dependency>> parseShadeOutput(Path buildOutput) throws IOException {
        try (Stream<String> lines = Files.lines(buildOutput);){
            Map<String, Set<Dependency>> map = ShadeParser.parseShadeOutput(lines);
            return map;
        }
    }

    @VisibleForTesting
    static Map<String, Set<Dependency>> parseShadeOutput(Stream<String> lines) {
        return ParserUtils.parsePluginOutput(lines.filter(line -> !line.contains(" Excluding ")), SHADE_NEXT_MODULE_PATTERN, ShadeParser::parseBlock);
    }

    private static Set<Dependency> parseBlock(Iterator<String> block) {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        Optional<Dependency> parsedDependency = ShadeParser.parseDependency(block.next());
        while (parsedDependency.isPresent()) {
            dependencies.add(parsedDependency.get());
            if (block.hasNext()) {
                parsedDependency = ShadeParser.parseDependency(block.next());
                continue;
            }
            parsedDependency = Optional.empty();
        }
        return dependencies;
    }

    @VisibleForTesting
    static Optional<Dependency> parseDependency(String line) {
        Matcher dependencyMatcher = SHADE_INCLUDE_MODULE_PATTERN.matcher(line);
        if (!dependencyMatcher.find()) {
            return Optional.empty();
        }
        return Optional.of(Dependency.create(dependencyMatcher.group("groupId"), dependencyMatcher.group("artifactId"), dependencyMatcher.group("version"), dependencyMatcher.group("classifier")));
    }

    private ShadeParser() {
    }
}

