/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.tools.ci.optional;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.tools.ci.utils.dependency.DependencyParser;
import org.apache.flink.tools.ci.utils.shade.ShadeParser;
import org.apache.flink.tools.ci.utils.shared.Dependency;
import org.apache.flink.tools.ci.utils.shared.DependencyTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadeOptionalChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ShadeOptionalChecker.class);

    public static void main(String[] args) throws IOException {
        Map<String, DependencyTree> dependenciesByModule;
        if (args.length < 2) {
            System.out.println("Usage: ShadeOptionalChecker <pathShadeBuildOutput> <pathMavenDependencyOutput>");
            System.exit(1);
        }
        Path shadeOutputPath = Paths.get(args[0], new String[0]);
        Path dependencyOutputPath = Paths.get(args[1], new String[0]);
        Map<String, Set<Dependency>> bundledDependenciesByModule = ShadeParser.parseShadeOutput(shadeOutputPath);
        Map<String, Set<Dependency>> violations = ShadeOptionalChecker.checkOptionalFlags(bundledDependenciesByModule, dependenciesByModule = DependencyParser.parseDependencyTreeOutput(dependencyOutputPath));
        if (!violations.isEmpty()) {
            LOG.error("{} modules bundle in total {} dependencies without them being marked as optional in the pom.", (Object)violations.keySet().size(), (Object)violations.values().stream().mapToInt(Collection::size).sum());
            LOG.error("\tIn order for shading to properly work within Flink we require all bundled dependencies to be marked as optional in the pom.");
            LOG.error("\tFor verification purposes we require the dependency tree from the dependency-plugin to show the dependency as either:");
            LOG.error("\t\ta) an optional dependency,");
            LOG.error("\t\tb) a transitive dependency of another optional dependency.");
            LOG.error("\tIn most cases adding '<optional>${flink.markBundledAsOptional}</optional>' to the bundled dependency is sufficient.");
            LOG.error("\tThere are some edge cases where a transitive dependency might be associated with the \"wrong\" dependency in the tree, for example if a test dependency also requires it.");
            LOG.error("\tIn such cases you need to adjust the poms so that the dependency shows up in the right spot. This may require adding an explicit dependency (Management) entry, excluding dependencies, or at times even reordering dependencies in the pom.");
            LOG.error("\tSee the Dependencies page in the wiki for details: https://cwiki.apache.org/confluence/display/FLINK/Dependencies");
            for (String moduleWithViolations : violations.keySet()) {
                Collection dependencyViolations = violations.get(moduleWithViolations);
                LOG.error("\tModule {} ({} violation{}):", new Object[]{moduleWithViolations, dependencyViolations.size(), dependencyViolations.size() == 1 ? "" : "s"});
                for (Dependency dependencyViolation : dependencyViolations) {
                    LOG.error("\t\t{}", (Object)dependencyViolation);
                }
            }
            System.exit(1);
        }
    }

    private static Map<String, Set<Dependency>> checkOptionalFlags(Map<String, Set<Dependency>> bundledDependenciesByModule, Map<String, DependencyTree> dependenciesByModule) {
        HashMap<String, Set<Dependency>> allViolations = new HashMap<String, Set<Dependency>>();
        for (String module : bundledDependenciesByModule.keySet()) {
            DependencyTree dependencyTree;
            LOG.debug("Checking module '{}'.", (Object)module);
            if (!dependenciesByModule.containsKey(module)) {
                throw new IllegalStateException(String.format("Module %s listed by shade-plugin, but not dependency-plugin.", module));
            }
            Collection bundledDependencies = bundledDependenciesByModule.get(module);
            Set<Dependency> violations = ShadeOptionalChecker.checkOptionalFlags(module, bundledDependencies, dependencyTree = dependenciesByModule.get(module));
            if (violations.isEmpty()) {
                LOG.info("OK: {}", (Object)module);
                continue;
            }
            allViolations.put(module, violations);
        }
        return allViolations;
    }

    @VisibleForTesting
    static Set<Dependency> checkOptionalFlags(String module, Collection<Dependency> bundledDependencies, DependencyTree dependencyTree) {
        bundledDependencies = bundledDependencies.stream().filter(dependency -> !dependency.getArtifactId().equals("flink-shaded-force-shading")).collect(Collectors.toSet());
        HashSet<Dependency> violations = new HashSet<Dependency>();
        if (bundledDependencies.isEmpty()) {
            LOG.debug("\tModule is not bundling any dependencies.");
            return violations;
        }
        List directTransitiveDependencies = dependencyTree.getDirectDependencies().stream().filter(dependency -> !ShadeOptionalChecker.isOptional(dependency) && !ShadeOptionalChecker.hasProvidedScope(dependency) && !ShadeOptionalChecker.hasTestScope(dependency) && !ShadeOptionalChecker.isCommonCompileDependency(dependency)).collect(Collectors.toList());
        if (directTransitiveDependencies.isEmpty()) {
            LOG.debug("Skipping deep-check of module {} because all direct dependencies are not transitive.", (Object)module);
            return violations;
        }
        LOG.debug("Running deep-check of module {} because there are direct dependencies that are transitive: {}", (Object)module, directTransitiveDependencies);
        for (Dependency bundledDependency : bundledDependencies) {
            LOG.debug("\tChecking dependency '{}'.", (Object)bundledDependency);
            List<Dependency> dependencyPath = dependencyTree.getPathTo(bundledDependency);
            boolean isOptional = dependencyPath.stream().anyMatch(parent -> parent.isOptional().orElse(false));
            if (isOptional) continue;
            violations.add(bundledDependency);
        }
        return violations;
    }

    private static boolean isOptional(Dependency dependency) {
        return dependency.isOptional().orElse(false);
    }

    private static boolean hasProvidedScope(Dependency dependency) {
        return "provided".equals(dependency.getScope().orElse(null));
    }

    private static boolean hasTestScope(Dependency dependency) {
        return "test".equals(dependency.getScope().orElse(null));
    }

    private static boolean isCommonCompileDependency(Dependency dependency) {
        return "flink-shaded-force-shading".equals(dependency.getArtifactId()) || "jsr305".equals(dependency.getArtifactId()) || "slf4j-api".equals(dependency.getArtifactId());
    }
}

