/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cep.nfa.sharedbuffer.Lockable;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;

public class SharedBufferNode {
    private final List<Lockable<SharedBufferEdge>> edges;

    public SharedBufferNode() {
        this.edges = new ArrayList<Lockable<SharedBufferEdge>>();
    }

    SharedBufferNode(List<Lockable<SharedBufferEdge>> edges) {
        this.edges = edges;
    }

    public List<Lockable<SharedBufferEdge>> getEdges() {
        return this.edges;
    }

    public void addEdge(SharedBufferEdge edge) {
        this.edges.add(new Lockable<SharedBufferEdge>(edge, 0));
    }

    public String toString() {
        return "SharedBufferNode{edges=" + this.edges + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedBufferNode that = (SharedBufferNode)o;
        return Objects.equals(this.edges, that.edges);
    }

    public int hashCode() {
        return Objects.hash(this.edges);
    }
}

