/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.sink;

import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.runtime.operators.sink.BatchDataSinkWriterOperator;
import org.apache.flink.cdc.runtime.operators.sink.DataSinkWriterOperator;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;

@Internal
public class DataSinkWriterOperatorFactory<CommT>
extends AbstractStreamOperatorFactory<CommittableMessage<CommT>>
implements OneInputStreamOperatorFactory<Event, CommittableMessage<CommT>>,
YieldingOperatorFactory<CommittableMessage<CommT>> {
    private final Sink<Event> sink;
    private final boolean isBounded;
    private final OperatorID schemaOperatorID;

    public DataSinkWriterOperatorFactory(Sink<Event> sink, boolean isBounded, OperatorID schemaOperatorID) {
        this.sink = sink;
        this.isBounded = isBounded;
        this.schemaOperatorID = schemaOperatorID;
    }

    public <T extends StreamOperator<CommittableMessage<CommT>>> T createStreamOperator(StreamOperatorParameters<CommittableMessage<CommT>> parameters) {
        if (this.isBounded) {
            BatchDataSinkWriterOperator writerOperator = new BatchDataSinkWriterOperator(this.sink, this.processingTimeService, this.getMailboxExecutor());
            writerOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
            return (T)((Object)writerOperator);
        }
        DataSinkWriterOperator writerOperator = new DataSinkWriterOperator(this.sink, this.processingTimeService, this.getMailboxExecutor(), this.schemaOperatorID);
        writerOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        return (T)((Object)writerOperator);
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        if (this.isBounded) {
            return BatchDataSinkWriterOperator.class;
        }
        return DataSinkWriterOperator.class;
    }
}

