/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.distributed;

import java.time.Duration;
import java.util.List;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.pipeline.SchemaChangeBehavior;
import org.apache.flink.cdc.common.route.RouteRule;
import org.apache.flink.cdc.common.sink.MetadataApplier;
import org.apache.flink.cdc.runtime.operators.schema.distributed.SchemaCoordinatorProvider;
import org.apache.flink.cdc.runtime.operators.schema.distributed.SchemaOperator;
import org.apache.flink.cdc.runtime.partitioning.PartitioningEvent;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.streaming.api.operators.CoordinatedOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;

@Internal
public class SchemaOperatorFactory
extends SimpleOperatorFactory<Event>
implements CoordinatedOperatorFactory<Event>,
OneInputStreamOperatorFactory<PartitioningEvent, Event> {
    private static final long serialVersionUID = 1L;
    private final MetadataApplier metadataApplier;
    private final List<RouteRule> routingRules;
    private final SchemaChangeBehavior schemaChangeBehavior;
    private final Duration rpcTimeout;

    public SchemaOperatorFactory(MetadataApplier metadataApplier, List<RouteRule> routingRules, Duration rpcTimeout, SchemaChangeBehavior schemaChangeBehavior, String timezone) {
        super((StreamOperator)new SchemaOperator(routingRules, rpcTimeout, schemaChangeBehavior, timezone));
        this.metadataApplier = metadataApplier;
        this.routingRules = routingRules;
        this.schemaChangeBehavior = schemaChangeBehavior;
        this.rpcTimeout = rpcTimeout;
    }

    public OperatorCoordinator.Provider getCoordinatorProvider(String operatorName, OperatorID operatorID) {
        return new SchemaCoordinatorProvider(operatorID, operatorName, this.metadataApplier, this.routingRules, this.schemaChangeBehavior, this.rpcTimeout);
    }
}

