/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.model;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import java.util.Collections;
import java.util.List;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.GenericArrayData;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.udf.UserDefinedFunction;
import org.apache.flink.cdc.common.udf.UserDefinedFunctionContext;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.runtime.model.ModelOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIEmbeddingModel
implements UserDefinedFunction {
    private static final Logger LOG = LoggerFactory.getLogger(OpenAIEmbeddingModel.class);
    private String modelName;
    private String host;
    private OpenAiEmbeddingModel embeddingModel;

    public ArrayData eval(String input) {
        return this.getEmbedding(input);
    }

    private ArrayData getEmbedding(String input) {
        if (input == null || input.trim().isEmpty()) {
            LOG.debug("Empty or null input provided for embedding.");
            return new GenericArrayData((Object[])new Float[0]);
        }
        TextSegment textSegment = new TextSegment(input, new Metadata());
        List embeddings = (List)this.embeddingModel.embedAll(Collections.singletonList(textSegment)).content();
        if (embeddings != null && !embeddings.isEmpty()) {
            List embeddingList = ((Embedding)embeddings.get(0)).vectorAsList();
            Object[] embeddingArray = embeddingList.toArray(new Float[0]);
            return new GenericArrayData(embeddingArray);
        }
        LOG.warn("No embedding results returned for input: {}", (Object)input);
        return new GenericArrayData((Object[])new Float[0]);
    }

    public DataType getReturnType() {
        return DataTypes.ARRAY((DataType)DataTypes.FLOAT());
    }

    public void open(UserDefinedFunctionContext userDefinedFunctionContext) {
        Configuration modelOptions = userDefinedFunctionContext.configuration();
        this.modelName = (String)modelOptions.get(ModelOptions.OPENAI_MODEL_NAME);
        Preconditions.checkNotNull((Object)this.modelName, (String)(ModelOptions.OPENAI_MODEL_NAME.key() + " should not be empty."));
        this.host = (String)modelOptions.get(ModelOptions.OPENAI_HOST);
        Preconditions.checkNotNull((Object)this.host, (String)(ModelOptions.OPENAI_HOST.key() + " should not be empty."));
        String apiKey = (String)modelOptions.get(ModelOptions.OPENAI_API_KEY);
        Preconditions.checkNotNull((Object)apiKey, (String)(ModelOptions.OPENAI_API_KEY.key() + " should not be empty."));
        LOG.info("Opening OpenAIEmbeddingModel " + this.modelName + " " + this.host);
        this.embeddingModel = OpenAiEmbeddingModel.builder().apiKey(apiKey).baseUrl(this.host).modelName(this.modelName).build();
    }

    public void close() {
        LOG.info("Closed OpenAIEmbeddingModel " + this.modelName + " " + this.host);
    }
}

