/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.model;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.util.Collections;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.udf.UserDefinedFunction;
import org.apache.flink.cdc.common.udf.UserDefinedFunctionContext;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.runtime.model.ModelOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIChatModel
implements UserDefinedFunction {
    private static final Logger LOG = LoggerFactory.getLogger(OpenAIChatModel.class);
    private OpenAiChatModel chatModel;
    private String modelName;
    private String host;
    private String prompt;

    public String eval(String input) {
        return this.chat(input);
    }

    private String chat(String input) {
        if (input == null || input.trim().isEmpty()) {
            LOG.warn("Empty or null input provided for embedding.");
            return "";
        }
        if (this.prompt != null) {
            input = this.prompt + ": " + input;
        }
        return ((AiMessage)this.chatModel.generate(Collections.singletonList(new UserMessage(input))).content()).text();
    }

    public DataType getReturnType() {
        return DataTypes.STRING();
    }

    public void open(UserDefinedFunctionContext userDefinedFunctionContext) {
        Configuration modelOptions = userDefinedFunctionContext.configuration();
        this.modelName = (String)modelOptions.get(ModelOptions.OPENAI_MODEL_NAME);
        Preconditions.checkNotNull((Object)this.modelName, (String)(ModelOptions.OPENAI_MODEL_NAME.key() + " should not be empty."));
        this.host = (String)modelOptions.get(ModelOptions.OPENAI_HOST);
        Preconditions.checkNotNull((Object)this.host, (String)(ModelOptions.OPENAI_HOST.key() + " should not be empty."));
        String apiKey = (String)modelOptions.get(ModelOptions.OPENAI_API_KEY);
        Preconditions.checkNotNull((Object)apiKey, (String)(ModelOptions.OPENAI_API_KEY.key() + " should not be empty."));
        this.prompt = (String)modelOptions.get(ModelOptions.OPENAI_CHAT_PROMPT);
        LOG.info("Opening OpenAIChatModel " + this.modelName + " " + this.host);
        this.chatModel = OpenAiChatModel.builder().apiKey(apiKey).baseUrl(this.host).modelName(this.modelName).build();
    }

    public void close() {
        LOG.info("Closed OpenAIChatModel " + this.modelName + " " + this.host);
    }
}

