/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source;

import java.time.Duration;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.configuration.ConfigOption;
import org.apache.flink.cdc.common.configuration.ConfigOptions;

@PublicEvolving
public class PostgresDataSourceOptions {
    public static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the PostgreSQL database server.");
    public static final ConfigOption<Integer> PG_PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)5432).withDescription("Integer port number of the PostgreSQL database server.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the PostgreSQL database to use when connecting to the PostgreSQL database server.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the PostgreSQL database server.");
    public static final ConfigOption<String> TABLES = ConfigOptions.key((String)"tables").stringType().noDefaultValue().withDescription("Table names of the PostgreSQL tables to monitor. Regular expressions are supported. It is important to note that the dot (.) is treated as a delimiter for database and table names. If there is a need to use a dot (.) in a regular expression to match any character, it is necessary to escape the dot with a backslash.eg. db0.\\.*, db1.user_table_[0-9]+, db[1-2].[app|web]_order_\\.*");
    public static final ConfigOption<String> DECODING_PLUGIN_NAME = ConfigOptions.key((String)"decoding.plugin.name").stringType().defaultValue((Object)"pgoutput").withDescription("The name of the Postgres logical decoding plug-in installed on the server.\nSupported values are decoderbufs and pgoutput.");
    public static final ConfigOption<String> SLOT_NAME = ConfigOptions.key((String)"slot.name").stringType().noDefaultValue().withDescription("The name of the PostgreSQL logical decoding slot that was created for streaming changes from a particular plug-in for a particular database/schema. The server uses this slot to stream events to the connector that you are configuring.");
    public static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().noDefaultValue().withDescription("The session time zone in database server. If not set, then ZoneId.systemDefault() is used to determine the server time zone.");
    public static final ConfigOption<String> SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN = ConfigOptions.key((String)"scan.incremental.snapshot.chunk.key-column").stringType().noDefaultValue().withDescription("The chunk key of table snapshot, captured tables are split into multiple chunks by a chunk key when read the snapshot of table.By default, the chunk key is the first column of the primary key and the chunk key is the RowId in oracle.This column must be a column of the primary key.");
    public static final ConfigOption<Integer> SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE = ConfigOptions.key((String)"scan.incremental.snapshot.chunk.size").intType().defaultValue((Object)8096).withDescription("The chunk size (number of rows) of table snapshot, captured tables are split into multiple chunks when read the snapshot of table.");
    public static final ConfigOption<Integer> SCAN_SNAPSHOT_FETCH_SIZE = ConfigOptions.key((String)"scan.snapshot.fetch.size").intType().defaultValue((Object)1024).withDescription("The maximum fetch size for per poll when read table snapshot.");
    public static final ConfigOption<Duration> CONNECT_TIMEOUT = ConfigOptions.key((String)"connect.timeout").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("The maximum time that the connector should wait after trying to connect to the PostgreSQL database server before timing out.");
    public static final ConfigOption<Integer> CONNECTION_POOL_SIZE = ConfigOptions.key((String)"connection.pool.size").intType().defaultValue((Object)20).withDescription("The connection pool size.");
    public static final ConfigOption<Integer> CONNECT_MAX_RETRIES = ConfigOptions.key((String)"connect.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times that the connector should retry to build PostgreSQL database server connection.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for PostgreSQL CDC consumer, valid enumerations are \"initial\", \"latest-offset\",\"snapshot\" or \"committed-offset\"");
    public static final ConfigOption<Duration> HEARTBEAT_INTERVAL = ConfigOptions.key((String)"heartbeat.interval").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("Optional interval of sending heartbeat event for tracing the latest available wal offsets");
    public static final ConfigOption<Double> SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.upper-bound").doubleType().defaultValue((Object)1000.0).withFallbackKeys(new String[]{"split-key.even-distribution.factor.upper-bound"}).withDescription("The upper bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    public static final ConfigOption<Double> SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.lower-bound").doubleType().defaultValue((Object)0.05).withFallbackKeys(new String[]{"split-key.even-distribution.factor.lower-bound"}).withDescription("The lower bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP = ConfigOptions.key((String)"scan.incremental.snapshot.backfill.skip").booleanType().defaultValue((Object)true).withDescription("Whether to skip backfill in snapshot reading phase. If backfill is skipped, changes on captured tables during snapshot phase will be consumed later in change log reading phase instead of being merged into the snapshot.WARNING: Skipping backfill might lead to data inconsistency because some change log events happened within the snapshot phase might be replayed (only at-least-once semantic is promised). For example updating an already updated value in snapshot, or deleting an already deleted entry in snapshot. These replayed change log events should be handled specially.");
    @Experimental
    public static final ConfigOption<Integer> CHUNK_META_GROUP_SIZE = ConfigOptions.key((String)"chunk-meta.group.size").intType().defaultValue((Object)1000).withDescription("The group size of chunk meta, if the meta size exceeds the group size, the meta will be divided into multiple groups.");
    @Experimental
    public static final ConfigOption<Double> CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.upper-bound").doubleType().defaultValue((Object)1000.0).withFallbackKeys(new String[]{"split-key.even-distribution.factor.upper-bound"}).withDescription("The upper bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query PostgreSQL for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    @Experimental
    public static final ConfigOption<Double> CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.lower-bound").doubleType().defaultValue((Object)0.05).withFallbackKeys(new String[]{"split-key.even-distribution.factor.lower-bound"}).withDescription("The lower bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query PostgreSQL for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED = ConfigOptions.key((String)"scan.incremental.close-idle-reader.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to close idle readers at the end of the snapshot phase. This feature depends on FLIP-147: Support Checkpoints After Tasks Finished. The flink version is required to be greater than or equal to 1.14 when enabling this feature.");
    @Experimental
    public static final ConfigOption<String> TABLES_EXCLUDE = ConfigOptions.key((String)"tables.exclude").stringType().noDefaultValue().withDescription("Table names of the PostgreSQL tables to Exclude. Regular expressions are supported. It is important to note that the dot (.) is treated as a delimiter for database and table names. If there is a need to use a dot (.) in a regular expression to match any character, it is necessary to escape the dot with a backslash.eg. db0.\\.*, db1.user_table_[0-9]+, db[1-2].[app|web]_order_\\.*");
    public static final ConfigOption<Integer> SCAN_LSN_COMMIT_CHECKPOINTS_DELAY = ConfigOptions.key((String)"scan.lsn-commit.checkpoints-num-delay").intType().defaultValue((Object)3).withDescription("The number of checkpoint delays before starting to commit the LSN offsets.\nBy setting this to higher value, the offset that is consumed by global slot will be committed after multiple checkpoint delays instead of after each checkpoint completion.\nThis allows continuous recycle of log files in stream phase.");
    @Experimental
    public static final ConfigOption<String> METADATA_LIST = ConfigOptions.key((String)"metadata.list").stringType().noDefaultValue().withDescription("List of readable metadata from SourceRecord to be passed to downstream, split by `,`. Available readable metadata are: op_ts.");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_SNAPSHOT_UNBOUNDED_CHUNK_FIRST_ENABLED = ConfigOptions.key((String)"scan.incremental.snapshot.unbounded-chunk-first.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to assign the unbounded chunks first during snapshot reading phase. This might help reduce the risk of the TaskManager experiencing an out-of-memory (OOM) error when taking a snapshot of the largest unbounded chunk.  Defaults to false.");
}

