/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.flink.translator;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.function.HashFunctionProvider;
import org.apache.flink.cdc.composer.flink.translator.OperatorUidGenerator;
import org.apache.flink.cdc.runtime.partitioning.BatchRegularPrePartitionOperator;
import org.apache.flink.cdc.runtime.partitioning.DistributedPrePartitionOperator;
import org.apache.flink.cdc.runtime.partitioning.EventPartitioner;
import org.apache.flink.cdc.runtime.partitioning.PartitioningEvent;
import org.apache.flink.cdc.runtime.partitioning.PartitioningEventKeySelector;
import org.apache.flink.cdc.runtime.partitioning.PostPartitionProcessor;
import org.apache.flink.cdc.runtime.partitioning.RegularPrePartitionOperator;
import org.apache.flink.cdc.runtime.typeutils.EventTypeInfo;
import org.apache.flink.cdc.runtime.typeutils.PartitioningEventTypeInfo;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;

@Internal
public class PartitioningTranslator {
    public DataStream<Event> translateRegular(DataStream<Event> input, int upstreamParallelism, int downstreamParallelism, OperatorID schemaOperatorID, HashFunctionProvider<DataChangeEvent> hashFunctionProvider, OperatorUidGenerator operatorUidGenerator) {
        return this.translateRegular(input, upstreamParallelism, downstreamParallelism, false, schemaOperatorID, hashFunctionProvider, operatorUidGenerator);
    }

    public DataStream<Event> translateRegular(DataStream<Event> input, int upstreamParallelism, int downstreamParallelism, boolean isBatchMode, OperatorID schemaOperatorID, HashFunctionProvider<DataChangeEvent> hashFunctionProvider, OperatorUidGenerator operatorUidGenerator) {
        SingleOutputStreamOperator singleOutputStreamOperator = input.transform(isBatchMode ? "BatchPrePartition" : "PrePartition", (TypeInformation)new PartitioningEventTypeInfo(), (OneInputStreamOperator)(isBatchMode ? new BatchRegularPrePartitionOperator(downstreamParallelism, hashFunctionProvider) : new RegularPrePartitionOperator(schemaOperatorID, downstreamParallelism, hashFunctionProvider))).uid(operatorUidGenerator.generateUid("pre-partition")).setParallelism(upstreamParallelism).partitionCustom((Partitioner)new EventPartitioner(), (KeySelector)new PartitioningEventKeySelector()).map((MapFunction)new PostPartitionProcessor(), (TypeInformation)new EventTypeInfo()).name(isBatchMode ? "BatchPostPartition" : "PostPartition").uid(operatorUidGenerator.generateUid("post-partition"));
        return isBatchMode ? singleOutputStreamOperator.setParallelism(downstreamParallelism) : singleOutputStreamOperator;
    }

    public DataStream<PartitioningEvent> translateDistributed(DataStream<Event> input, int upstreamParallelism, int downstreamParallelism, HashFunctionProvider<DataChangeEvent> hashFunctionProvider) {
        return input.transform("Partitioning", (TypeInformation)new PartitioningEventTypeInfo(), (OneInputStreamOperator)new DistributedPrePartitionOperator(downstreamParallelism, hashFunctionProvider)).setParallelism(upstreamParallelism).partitionCustom((Partitioner)new EventPartitioner(), (KeySelector)new PartitioningEventKeySelector());
    }
}

