/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.config;

import io.debezium.config.Configuration;
import java.util.Properties;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;

public abstract class BaseSourceConfig
implements SourceConfig {
    private static final long serialVersionUID = 1L;
    protected final StartupOptions startupOptions;
    protected final int splitSize;
    protected final int splitMetaGroupSize;
    protected final double distributionFactorUpper;
    protected final double distributionFactorLower;
    protected final boolean includeSchemaChanges;
    protected final boolean closeIdleReaders;
    protected final boolean skipSnapshotBackfill;
    protected final boolean isScanNewlyAddedTableEnabled;
    protected final boolean assignUnboundedChunkFirst;
    protected final Properties dbzProperties;
    protected transient Configuration dbzConfiguration;

    public BaseSourceConfig(StartupOptions startupOptions, int splitSize, int splitMetaGroupSize, double distributionFactorUpper, double distributionFactorLower, boolean includeSchemaChanges, boolean closeIdleReaders, boolean skipSnapshotBackfill, boolean isScanNewlyAddedTableEnabled, Properties dbzProperties, Configuration dbzConfiguration, boolean assignUnboundedChunkFirst) {
        this.startupOptions = startupOptions;
        this.splitSize = splitSize;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.distributionFactorUpper = distributionFactorUpper;
        this.distributionFactorLower = distributionFactorLower;
        this.includeSchemaChanges = includeSchemaChanges;
        this.closeIdleReaders = closeIdleReaders;
        this.skipSnapshotBackfill = skipSnapshotBackfill;
        this.isScanNewlyAddedTableEnabled = isScanNewlyAddedTableEnabled;
        this.dbzProperties = dbzProperties;
        this.dbzConfiguration = dbzConfiguration;
        this.assignUnboundedChunkFirst = assignUnboundedChunkFirst;
    }

    @Override
    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    @Override
    public int getSplitSize() {
        return this.splitSize;
    }

    @Override
    public int getSplitMetaGroupSize() {
        return this.splitMetaGroupSize;
    }

    public double getDistributionFactorUpper() {
        return this.distributionFactorUpper;
    }

    public double getDistributionFactorLower() {
        return this.distributionFactorLower;
    }

    @Override
    public boolean isIncludeSchemaChanges() {
        return this.includeSchemaChanges;
    }

    @Override
    public boolean isCloseIdleReaders() {
        return this.closeIdleReaders;
    }

    public Properties getDbzProperties() {
        return this.dbzProperties;
    }

    public Configuration getDbzConfiguration() {
        return Configuration.from((Properties)this.dbzProperties);
    }

    @Override
    public boolean isSkipSnapshotBackfill() {
        return this.skipSnapshotBackfill;
    }

    @Override
    public boolean isAssignUnboundedChunkFirst() {
        return this.assignUnboundedChunkFirst;
    }
}

