/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.api.avro.FSDataInputStreamWrapper;
import org.apache.flink.api.common.io.CheckpointableInputFormat;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroInputFormat<E>
extends FileInputFormat<E>
implements ResultTypeQueryable<E>,
CheckpointableInputFormat<FileInputSplit, Tuple2<Long, Long>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AvroInputFormat.class);
    private final Class<E> avroValueType;
    private boolean reuseAvroValue = true;
    private transient DataFileReader<E> dataFileReader;
    private transient long end;
    private transient long recordsReadSinceLastSync;
    private long lastSync = -1L;

    public AvroInputFormat(Path filePath, Class<E> type) {
        super(filePath);
        this.avroValueType = type;
    }

    public void setReuseAvroValue(boolean reuseAvroValue) {
        this.reuseAvroValue = reuseAvroValue;
    }

    public void setUnsplittable(boolean unsplittable) {
        this.unsplittable = unsplittable;
    }

    public TypeInformation<E> getProducedType() {
        return TypeExtractor.getForClass(this.avroValueType);
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.dataFileReader = this.initReader(split);
        this.dataFileReader.sync(split.getStart());
        this.lastSync = this.dataFileReader.previousSync();
    }

    private DataFileReader<E> initReader(FileInputSplit split) throws IOException {
        GenericDatumReader datumReader;
        if (GenericRecord.class == this.avroValueType) {
            datumReader = new GenericDatumReader();
        } else {
            Object object = datumReader = SpecificRecordBase.class.isAssignableFrom(this.avroValueType) ? new SpecificDatumReader(this.avroValueType) : new ReflectDatumReader(this.avroValueType);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Opening split {}", (Object)split);
        }
        FSDataInputStreamWrapper in = new FSDataInputStreamWrapper(this.stream, split.getPath().getFileSystem().getFileStatus(split.getPath()).getLen());
        DataFileReader dataFileReader = (DataFileReader)DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded SCHEMA: {}", (Object)dataFileReader.getSchema());
        }
        this.end = split.getStart() + split.getLength();
        this.recordsReadSinceLastSync = 0L;
        return dataFileReader;
    }

    public boolean reachedEnd() throws IOException {
        return !this.dataFileReader.hasNext() || this.dataFileReader.pastSync(this.end);
    }

    public long getRecordsReadFromBlock() {
        return this.recordsReadSinceLastSync;
    }

    public E nextRecord(E reuseValue) throws IOException {
        if (this.reachedEnd()) {
            return null;
        }
        if (this.dataFileReader.previousSync() != this.lastSync) {
            this.lastSync = this.dataFileReader.previousSync();
            this.recordsReadSinceLastSync = 0L;
        }
        ++this.recordsReadSinceLastSync;
        if (this.reuseAvroValue) {
            return (E)this.dataFileReader.next(reuseValue);
        }
        if (GenericRecord.class == this.avroValueType) {
            return (E)this.dataFileReader.next();
        }
        return (E)this.dataFileReader.next(InstantiationUtil.instantiate(this.avroValueType, Object.class));
    }

    public Tuple2<Long, Long> getCurrentState() throws IOException {
        return new Tuple2((Object)this.lastSync, (Object)this.recordsReadSinceLastSync);
    }

    public void reopen(FileInputSplit split, Tuple2<Long, Long> state) throws IOException {
        Preconditions.checkNotNull((Object)split, (String)"reopen() cannot be called on a null split.");
        Preconditions.checkNotNull(state, (String)"reopen() cannot be called with a null initial state.");
        try {
            this.open(split);
        }
        finally {
            if ((Long)state.f0 != -1L) {
                this.lastSync = (Long)state.f0;
                this.recordsReadSinceLastSync = (Long)state.f1;
            }
        }
        if (this.lastSync != -1L) {
            this.dataFileReader.seek(this.lastSync);
            int i = 0;
            while ((long)i < this.recordsReadSinceLastSync) {
                this.dataFileReader.next(null);
                ++i;
            }
        }
    }
}

