/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.avro.Schema;
import org.apache.flink.api.io.avro.example.User;
import org.apache.flink.api.java.io.AvroOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class AvroOutputFormatTest {
    @Test
    public void testSetCodec() throws Exception {
        AvroOutputFormat outputFormat = new AvroOutputFormat(User.class);
        try {
            outputFormat.setCodec(AvroOutputFormat.Codec.SNAPPY);
        }
        catch (Exception ex) {
            Assert.fail((String)"unexpected exception");
        }
    }

    @Test
    public void testSetCodecError() throws Exception {
        boolean error = false;
        AvroOutputFormat outputFormat = new AvroOutputFormat(User.class);
        try {
            outputFormat.setCodec(null);
        }
        catch (Exception ex) {
            error = true;
        }
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testSerialization() throws Exception {
        this.serializeAndDeserialize(null, null);
        this.serializeAndDeserialize(null, User.SCHEMA$);
        for (AvroOutputFormat.Codec codec : AvroOutputFormat.Codec.values()) {
            this.serializeAndDeserialize(codec, null);
            this.serializeAndDeserialize(codec, User.SCHEMA$);
        }
    }

    private void serializeAndDeserialize(AvroOutputFormat.Codec codec, Schema schema) throws IOException, ClassNotFoundException {
        AvroOutputFormat outputFormat = new AvroOutputFormat(User.class);
        if (codec != null) {
            outputFormat.setCodec(codec);
        }
        if (schema != null) {
            outputFormat.setSchema(schema);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(outputFormat);
        }
        var6_6 = null;
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
            Object o = ois.readObject();
            Assert.assertTrue((boolean)(o instanceof AvroOutputFormat));
            AvroOutputFormat restored = (AvroOutputFormat)o;
            AvroOutputFormat.Codec restoredCodec = (AvroOutputFormat.Codec)Whitebox.getInternalState((Object)restored, (String)"codec");
            Schema restoredSchema = (Schema)Whitebox.getInternalState((Object)restored, (String)"userDefinedSchema");
            Assert.assertTrue((boolean)(codec != null ? restoredCodec == codec : restoredCodec == null));
            Assert.assertTrue((boolean)(schema != null ? restoredSchema.equals((Object)schema) : restoredSchema == null));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testCompression() throws Exception {
        Path outputPath = new Path(File.createTempFile("avro-output-file", "avro").getAbsolutePath());
        AvroOutputFormat outputFormat = new AvroOutputFormat(outputPath, User.class);
        outputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        Path compressedOutputPath = new Path(File.createTempFile("avro-output-file", "compressed.avro").getAbsolutePath());
        AvroOutputFormat compressedOutputFormat = new AvroOutputFormat(compressedOutputPath, User.class);
        compressedOutputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        compressedOutputFormat.setCodec(AvroOutputFormat.Codec.SNAPPY);
        this.output((AvroOutputFormat<User>)outputFormat);
        this.output((AvroOutputFormat<User>)compressedOutputFormat);
        Assert.assertTrue((this.fileSize(outputPath) > this.fileSize(compressedOutputPath) ? 1 : 0) != 0);
        FileSystem fs = FileSystem.getLocalFileSystem();
        fs.delete(outputPath, false);
        fs.delete(compressedOutputPath, false);
    }

    private long fileSize(Path path) throws IOException {
        return path.getFileSystem().getFileStatus(path).getLen();
    }

    private void output(AvroOutputFormat<User> outputFormat) throws IOException {
        outputFormat.configure(new Configuration());
        outputFormat.open(1, 1);
        for (int i = 0; i < 100; ++i) {
            outputFormat.writeRecord((Object)new User("testUser", 1, "blue"));
        }
        outputFormat.close();
    }
}

