/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.AvroInputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class AvroInputFormatTypeExtractionTest {
    @Test
    public void testTypeExtraction() {
        try {
            AvroInputFormat format = new AvroInputFormat(new Path("file:///ignore/this/file"), MyAvroType.class);
            TypeInformation typeInfoDirect = TypeExtractor.getInputFormatTypes((InputFormat)format);
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.createInput((InputFormat)format);
            TypeInformation typeInfoDataSet = input.getType();
            Assert.assertTrue((boolean)(typeInfoDirect instanceof PojoTypeInfo));
            Assert.assertTrue((boolean)(typeInfoDataSet instanceof PojoTypeInfo));
            Assert.assertEquals(MyAvroType.class, (Object)typeInfoDirect.getTypeClass());
            Assert.assertEquals(MyAvroType.class, (Object)typeInfoDataSet.getTypeClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static final class MyAvroType {
        public String theString;
        public MyAvroType recursive;
        private double aDouble;

        public double getaDouble() {
            return this.aDouble;
        }

        public void setaDouble(double aDouble) {
            this.aDouble = aDouble;
        }

        public void setTheString(String theString) {
            this.theString = theString;
        }

        public String getTheString() {
            return this.theString;
        }
    }
}

