/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.io.avro.example;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.io.avro.example.User;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;

public class AvroTypeExample {
    public static void main(String[] args) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource users = env.createInput((InputFormat)new UserGeneratingInputFormat());
        users.map((MapFunction)new NumberExtractingMapper()).groupBy(new int[]{1}).reduceGroup((GroupReduceFunction)new ConcatenatingReducer()).print();
    }

    public static final class UserGeneratingInputFormat
    extends GenericInputFormat<User> {
        private static final long serialVersionUID = 1L;
        private static final int NUM = 100;
        private final Random rnd = new Random(32498562304986L);
        private static final String[] NAMES = new String[]{"Peter", "Bob", "Liddy", "Alexander", "Stan"};
        private static final String[] COLORS = new String[]{"mauve", "crimson", "copper", "sky", "grass"};
        private int count;

        public boolean reachedEnd() throws IOException {
            return this.count >= 100;
        }

        public User nextRecord(User reuse) throws IOException {
            ++this.count;
            User u = new User();
            u.setName(NAMES[this.rnd.nextInt(NAMES.length)]);
            u.setFavoriteColor(COLORS[this.rnd.nextInt(COLORS.length)]);
            u.setFavoriteNumber(this.rnd.nextInt(87));
            return u;
        }
    }

    public static final class ConcatenatingReducer
    implements GroupReduceFunction<Tuple2<User, Integer>, Tuple2<Integer, String>> {
        public void reduce(Iterable<Tuple2<User, Integer>> values, Collector<Tuple2<Integer, String>> out) throws Exception {
            int number = 0;
            StringBuilder colors = new StringBuilder();
            for (Tuple2<User, Integer> u : values) {
                number = (Integer)u.f1;
                colors.append(((User)((Object)u.f0)).getFavoriteColor()).append(" - ");
            }
            colors.setLength(colors.length() - 3);
            out.collect((Object)new Tuple2((Object)number, (Object)colors.toString()));
        }
    }

    public static final class NumberExtractingMapper
    implements MapFunction<User, Tuple2<User, Integer>> {
        public Tuple2<User, Integer> map(User user) {
            return new Tuple2((Object)user, (Object)user.getFavoriteNumber());
        }
    }
}

