/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.io.avro;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.io.avro.AvroRecordInputFormatTest;
import org.apache.flink.api.io.avro.generated.Fixed16;
import org.apache.flink.api.io.avro.generated.User;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.AvroInputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.Path;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.util.Collector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AvroPojoTest
extends MultipleProgramsTestBase {
    private File inFile;
    private String resultPath;
    private String expected;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    public AvroPojoTest(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Before
    public void before() throws Exception {
        this.resultPath = this.tempFolder.newFile().toURI().toString();
        this.inFile = this.tempFolder.newFile();
        AvroRecordInputFormatTest.writeTestFile(this.inFile);
    }

    @After
    public void after() throws Exception {
        AvroPojoTest.compareResultsByLinesInMemory((String)this.expected, (String)this.resultPath);
    }

    @Test
    public void testSimpleAvroRead() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        MapOperator usersDS = env.createInput((InputFormat)users).map((MapFunction)new MapFunction<User, User>(){

            public User map(User value) throws Exception {
                value.setTypeMap(null);
                return value;
            }
        });
        usersDS.writeAsText(this.resultPath);
        env.execute("Simple Avro read job");
        this.expected = "{\"name\": \"Alyssa\", \"favorite_number\": 256, \"favorite_color\": null, \"type_long_test\": null, \"type_double_test\": 123.45, \"type_null_test\": null, \"type_bool_test\": true, \"type_array_string\": [\"ELEMENT 1\", \"ELEMENT 2\"], \"type_array_boolean\": [true, false], \"type_nullable_array\": null, \"type_enum\": \"GREEN\", \"type_map\": null, \"type_fixed\": null, \"type_union\": null, \"type_nested\": {\"num\": 239, \"street\": \"Baker Street\", \"city\": \"London\", \"state\": \"London\", \"zip\": \"NW1 6XE\"}}\n{\"name\": \"Charlie\", \"favorite_number\": null, \"favorite_color\": \"blue\", \"type_long_test\": 1337, \"type_double_test\": 1.337, \"type_null_test\": null, \"type_bool_test\": false, \"type_array_string\": [], \"type_array_boolean\": [], \"type_nullable_array\": null, \"type_enum\": \"RED\", \"type_map\": null, \"type_fixed\": null, \"type_union\": null, \"type_nested\": {\"num\": 239, \"street\": \"Baker Street\", \"city\": \"London\", \"state\": \"London\", \"zip\": \"NW1 6XE\"}}\n";
    }

    @Test
    public void testSerializeWithAvro() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().enableForceAvro();
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        MapOperator usersDS = env.createInput((InputFormat)users).map((MapFunction)new MapFunction<User, User>(){

            public User map(User value) throws Exception {
                HashMap<CharSequence, Long> ab = new HashMap<CharSequence, Long>(1);
                ab.put("hehe", 12L);
                value.setTypeMap(ab);
                return value;
            }
        });
        usersDS.writeAsText(this.resultPath);
        env.execute("Simple Avro read job");
        this.expected = "{\"name\": \"Alyssa\", \"favorite_number\": 256, \"favorite_color\": null, \"type_long_test\": null, \"type_double_test\": 123.45, \"type_null_test\": null, \"type_bool_test\": true, \"type_array_string\": [\"ELEMENT 1\", \"ELEMENT 2\"], \"type_array_boolean\": [true, false], \"type_nullable_array\": null, \"type_enum\": \"GREEN\", \"type_map\": {\"hehe\": 12}, \"type_fixed\": null, \"type_union\": null, \"type_nested\": {\"num\": 239, \"street\": \"Baker Street\", \"city\": \"London\", \"state\": \"London\", \"zip\": \"NW1 6XE\"}}\n{\"name\": \"Charlie\", \"favorite_number\": null, \"favorite_color\": \"blue\", \"type_long_test\": 1337, \"type_double_test\": 1.337, \"type_null_test\": null, \"type_bool_test\": false, \"type_array_string\": [], \"type_array_boolean\": [], \"type_nullable_array\": null, \"type_enum\": \"RED\", \"type_map\": {\"hehe\": 12}, \"type_fixed\": null, \"type_union\": null, \"type_nested\": {\"num\": 239, \"street\": \"Baker Street\", \"city\": \"London\", \"state\": \"London\", \"zip\": \"NW1 6XE\"}}\n";
    }

    @Test
    public void testKeySelection() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().enableObjectReuse();
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        DataSource usersDS = env.createInput((InputFormat)users);
        GroupReduceOperator res = usersDS.groupBy(new String[]{"name"}).reduceGroup((GroupReduceFunction)new GroupReduceFunction<User, Tuple2<String, Integer>>(){

            public void reduce(Iterable<User> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (User u : values) {
                    out.collect((Object)new Tuple2((Object)u.getName().toString(), (Object)1));
                }
            }
        });
        res.writeAsText(this.resultPath);
        env.execute("Avro Key selection");
        this.expected = "(Alyssa,1)\n(Charlie,1)\n";
    }

    @Test
    public void testWithAvroGenericSer() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().enableForceAvro();
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        DataSource usersDS = env.createInput((InputFormat)users);
        GroupReduceOperator res = usersDS.groupBy((KeySelector)new KeySelector<User, String>(){

            public String getKey(User value) throws Exception {
                return String.valueOf(value.getName());
            }
        }).reduceGroup((GroupReduceFunction)new GroupReduceFunction<User, Tuple2<String, Integer>>(){

            public void reduce(Iterable<User> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (User u : values) {
                    out.collect((Object)new Tuple2((Object)u.getName().toString(), (Object)1));
                }
            }
        });
        res.writeAsText(this.resultPath);
        env.execute("Avro Key selection");
        this.expected = "(Charlie,1)\n(Alyssa,1)\n";
    }

    @Test
    public void testWithKryoGenericSer() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().enableForceKryo();
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        DataSource usersDS = env.createInput((InputFormat)users);
        GroupReduceOperator res = usersDS.groupBy((KeySelector)new KeySelector<User, String>(){

            public String getKey(User value) throws Exception {
                return String.valueOf(value.getName());
            }
        }).reduceGroup((GroupReduceFunction)new GroupReduceFunction<User, Tuple2<String, Integer>>(){

            public void reduce(Iterable<User> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (User u : values) {
                    out.collect((Object)new Tuple2((Object)u.getName().toString(), (Object)1));
                }
            }
        });
        res.writeAsText(this.resultPath);
        env.execute("Avro Key selection");
        this.expected = "(Charlie,1)\n(Alyssa,1)\n";
    }

    @Test
    public void testAllFields() throws Exception {
        for (String fieldName : Arrays.asList("name", "type_enum", "type_double_test")) {
            this.testField(fieldName);
        }
    }

    private void testField(final String fieldName) throws Exception {
        this.before();
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        DataSource usersDS = env.createInput((InputFormat)users);
        GroupReduceOperator res = usersDS.groupBy(new String[]{fieldName}).reduceGroup((GroupReduceFunction)new GroupReduceFunction<User, Object>(){

            public void reduce(Iterable<User> values, Collector<Object> out) throws Exception {
                for (User u : values) {
                    out.collect(u.get(fieldName));
                }
            }
        });
        res.writeAsText(this.resultPath);
        env.execute("Simple Avro read job");
        ExecutionConfig ec = env.getConfig();
        Assert.assertTrue((boolean)ec.getRegisteredKryoTypes().contains(Fixed16.class));
        if (fieldName.equals("name")) {
            this.expected = "Alyssa\nCharlie";
        } else if (fieldName.equals("type_enum")) {
            this.expected = "GREEN\nRED\n";
        } else if (fieldName.equals("type_double_test")) {
            this.expected = "123.45\n1.337\n";
        } else {
            Assert.fail((String)"Unknown field");
        }
        this.after();
    }
}

