/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.avro.AvroFormatOptions;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.WrappingRuntimeException;

public class AvroSerializationSchema<T>
implements SerializationSchema<T> {
    private static final long serialVersionUID = -8766681879020862312L;
    private Class<T> recordClazz;
    private String schemaString;
    private transient Schema schema;
    private transient GenericDatumWriter<T> datumWriter;
    private transient ByteArrayOutputStream arrayOutputStream;
    private final AvroFormatOptions.AvroEncoding encoding;
    private transient Encoder encoder;

    public static <T extends SpecificRecord> AvroSerializationSchema<T> forSpecific(Class<T> tClass) {
        return AvroSerializationSchema.forSpecific(tClass, AvroFormatOptions.AvroEncoding.BINARY);
    }

    public static <T extends SpecificRecord> AvroSerializationSchema<T> forSpecific(Class<T> tClass, AvroFormatOptions.AvroEncoding encoding) {
        return new AvroSerializationSchema<T>(tClass, null, encoding);
    }

    public static AvroSerializationSchema<GenericRecord> forGeneric(Schema schema) {
        return AvroSerializationSchema.forGeneric(schema, AvroFormatOptions.AvroEncoding.BINARY);
    }

    public static AvroSerializationSchema<GenericRecord> forGeneric(Schema schema, AvroFormatOptions.AvroEncoding encoding) {
        return new AvroSerializationSchema<GenericRecord>(GenericRecord.class, schema, encoding);
    }

    protected AvroSerializationSchema(Class<T> recordClazz, @Nullable Schema schema, AvroFormatOptions.AvroEncoding encoding) {
        Preconditions.checkNotNull(recordClazz, (String)"Avro record class must not be null.");
        this.recordClazz = recordClazz;
        this.schema = schema;
        this.schemaString = schema != null ? schema.toString() : null;
        this.encoding = encoding;
    }

    public Schema getSchema() {
        return this.schema;
    }

    protected Encoder getEncoder() {
        return this.encoder;
    }

    protected GenericDatumWriter<T> getDatumWriter() {
        return this.datumWriter;
    }

    protected ByteArrayOutputStream getOutputStream() {
        return this.arrayOutputStream;
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        if (this.schemaString != null) {
            this.schema = new Schema.Parser().parse(this.schemaString);
        }
    }

    public byte[] serialize(T object) {
        this.checkAvroInitialized();
        if (object == null) {
            return null;
        }
        try {
            this.datumWriter.write(object, this.encoder);
            this.encoder.flush();
            byte[] bytes = this.arrayOutputStream.toByteArray();
            this.arrayOutputStream.reset();
            return bytes;
        }
        catch (IOException e) {
            throw new WrappingRuntimeException("Failed to serialize schema registry.", (Throwable)e);
        }
    }

    protected void checkAvroInitialized() {
        if (this.datumWriter != null) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (SpecificRecord.class.isAssignableFrom(this.recordClazz)) {
            Schema schema = SpecificData.get().getSchema(this.recordClazz);
            this.datumWriter = new SpecificDatumWriter(schema);
            this.schema = schema;
        } else {
            this.schema = new Schema.Parser().parse(this.schemaString);
            GenericData genericData = new GenericData(cl);
            this.datumWriter = new GenericDatumWriter(this.schema, genericData);
        }
        this.arrayOutputStream = new ByteArrayOutputStream();
        if (this.encoding == AvroFormatOptions.AvroEncoding.JSON) {
            try {
                this.encoder = EncoderFactory.get().jsonEncoder(this.schema, (OutputStream)this.arrayOutputStream);
            }
            catch (IOException e) {
                throw new WrappingRuntimeException("Failed to create Avro encoder.", (Throwable)e);
            }
        } else {
            this.encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)this.arrayOutputStream, null);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroSerializationSchema that = (AvroSerializationSchema)o;
        return this.recordClazz.equals(that.recordClazz) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.recordClazz, this.schema);
    }
}

