/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Map;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FormatDescriptor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class Avro
extends FormatDescriptor {
    private Class<? extends SpecificRecord> recordClass;
    private String avroSchema;

    public Avro() {
        super("avro", 1);
    }

    public Avro recordClass(Class<? extends SpecificRecord> recordClass) {
        Preconditions.checkNotNull(recordClass);
        this.recordClass = recordClass;
        return this;
    }

    public Avro avroSchema(String avroSchema) {
        Preconditions.checkNotNull((Object)avroSchema);
        this.avroSchema = avroSchema;
        return this;
    }

    protected Map<String, String> toFormatProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        if (null != this.recordClass) {
            properties.putClass("format.record-class", this.recordClass);
        }
        if (null != this.avroSchema) {
            properties.putString("format.avro-schema", this.avroSchema);
        }
        return properties.asMap();
    }
}

