/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.User;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.filter.FilteringResponseWrapper;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.apache.felix.webconsole.internal.servlet.AbstractPluginAdapter;
import org.apache.felix.webconsole.internal.servlet.BasicWebConsoleSecurityProvider;
import org.apache.felix.webconsole.internal.servlet.ConfigurationMetatypeSupport;
import org.apache.felix.webconsole.internal.servlet.ConfigurationSupport;
import org.apache.felix.webconsole.internal.servlet.ConfigurationUtil;
import org.apache.felix.webconsole.internal.servlet.OsgiManagerHttpContext;
import org.apache.felix.webconsole.internal.servlet.Plugin;
import org.apache.felix.webconsole.internal.servlet.PluginHolder;
import org.apache.felix.webconsole.spi.SecurityProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.servlet.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OsgiManager
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_NO_REDIRECT_AFTER_ACTION = "_noredir_";
    private static final String COOKIE_LOCALE = "felix-webconsole-locale";
    private static final String FRAMEWORK_PROP_MANAGER_ROOT = "felix.webconsole.manager.root";
    private static final String FRAMEWORK_PROP_REALM = "felix.webconsole.realm";
    private static final String FRAMEWORK_PROP_USER_NAME = "felix.webconsole.username";
    private static final String FRAMEWORK_PROP_PASSWORD = "felix.webconsole.password";
    private static final String FRAMEWORK_PROP_LOCALE = "felix.webconsole.locale";
    private static final String FRAMEWORK_SHUTDOWN_TIMEOUT = "felix.webconsole.shutdown.timeout";
    private static final String FRAMEWORK_RELOAD_TIMEOUT = "felix.webconsole.reload.timeout";
    static final String FRAMEWORK_PROP_SECURITY_PROVIDERS = "felix.webconsole.security.providers";
    static final String PROP_MANAGER_ROOT = "manager.root";
    static final String PROP_DEFAULT_RENDER = "default.render";
    static final String PROP_REALM = "realm";
    static final String PROP_USER_NAME = "username";
    static final String PROP_PASSWORD = "password";
    static final String PROP_CATEGORY = "category";
    static final String PROP_ENABLED_PLUGINS = "plugins";
    static final String PROP_LOCALE = "locale";
    static final String PROP_ENABLE_SECRET_HEURISTIC = "secret.heuristic.enabled";
    static final String PROP_HTTP_SERVICE_SELECTOR = "http.service.filter";
    public static final String PROP_SHUTDOWN_TIMEOUT = "shutdown.timeout";
    public static final String PROP_RELOAD_TIMEOUT = "reload.timeout";
    static final String DEFAULT_PAGE = "bundles";
    static final String DEFAULT_REALM = "OSGi Management Console";
    static final String DEFAULT_USER_NAME = "admin";
    static final String DEFAULT_PASSWORD = "{sha-256}jGl25bVBBBW96Qi9Te4V37Fnqchz/Eu4qB9vKrRIqRg=";
    static final String DEFAULT_CATEGORY = "Main";
    static final int DEFAULT_SHUTDOWN_TIMEOUT = 5;
    static final int DEFAULT_RELOAD_TIMEOUT = 40;
    public static final boolean DEFAULT_ENABLE_SECRET_HEURISTIC = false;
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    static final String DEFAULT_MANAGER_ROOT = "/system/console";
    static final String[] PLUGIN_CLASSES = new String[]{"org.apache.felix.webconsole.internal.configuration.ConfigurationAdminConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.PreferencesConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.WireAdminConfigurationPrinter", "org.apache.felix.webconsole.internal.core.BundlesConfigurationPrinter", "org.apache.felix.webconsole.internal.core.CapabilitiesPrinter", "org.apache.felix.webconsole.internal.core.FrameworkPropertiesPrinter", "org.apache.felix.webconsole.internal.core.PermissionsConfigurationPrinter", "org.apache.felix.webconsole.internal.core.ServicesConfigurationPrinter", "org.apache.felix.webconsole.internal.misc.SystemPropertiesPrinter", "org.apache.felix.webconsole.internal.misc.ThreadPrinter"};
    private static final String SERVLEXT_CONTEXT_NAME = "org.apache.felix.webconsole";
    public static volatile boolean ENABLE_SECRET_HEURISTICS = false;
    private BundleContext bundleContext;
    private PluginHolder holder;
    private ServiceTracker<org.apache.felix.webconsole.spi.BrandingPlugin, org.apache.felix.webconsole.spi.BrandingPlugin> brandingTracker;
    private ServiceTracker<SecurityProvider, SecurityProvider> securityProviderTracker;
    private ServiceRegistration configurationListener;
    private volatile List<OsgiManagerPlugin> osgiManagerPlugins = new ArrayList<OsgiManagerPlugin>();
    private volatile String webManagerRoot;
    private ServiceRegistration<SecurityProvider> basicSecurityServiceRegistration;
    private volatile ServiceRegistration<ServletContextHelper> servletContextRegistration;
    private volatile ServiceRegistration<Servlet> servletRegistration;
    private Map<String, Object> defaultConfiguration;
    private volatile Map<String, Object> configuration;
    private volatile Locale configuredLocale;
    final ConcurrentSkipListSet<String> registeredSecurityProviders = new ConcurrentSkipListSet();
    final Set<String> requiredSecurityProviders;
    final ResourceBundleManager resourceBundleManager;
    private volatile String defaultCategory = "Main";
    private Map<String, String> langMap;

    public OsgiManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.holder = new PluginHolder(this, bundleContext);
        for (int i = 0; i < PLUGIN_CLASSES.length; ++i) {
            String pluginClassName = PLUGIN_CLASSES[i];
            OsgiManagerPlugin plugin = this.createInternalPlugin(pluginClassName);
            if (plugin == null) continue;
            plugin.activate(bundleContext);
            this.osgiManagerPlugins.add(plugin);
        }
        this.resourceBundleManager = new ResourceBundleManager(this.getBundleContext());
        this.holder.open();
        this.brandingTracker = new BrandingServiceTracker(this);
        this.brandingTracker.open();
        this.requiredSecurityProviders = OsgiManager.splitCommaSeparatedString(bundleContext.getProperty(FRAMEWORK_PROP_SECURITY_PROVIDERS));
        this.securityProviderTracker = new ServiceTracker(bundleContext, SecurityProvider.class, (ServiceTrackerCustomizer)new UpdateDependenciesStateCustomizer());
        this.securityProviderTracker.open();
        this.defaultConfiguration = new HashMap<String, Object>();
        this.defaultConfiguration.put(PROP_MANAGER_ROOT, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_MANAGER_ROOT, DEFAULT_MANAGER_ROOT));
        this.defaultConfiguration.put(PROP_REALM, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_REALM, DEFAULT_REALM));
        this.defaultConfiguration.put(PROP_USER_NAME, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_USER_NAME, DEFAULT_USER_NAME));
        this.defaultConfiguration.put(PROP_PASSWORD, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_PASSWORD, DEFAULT_PASSWORD));
        this.defaultConfiguration.put(PROP_LOCALE, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_LOCALE, null));
        this.defaultConfiguration.put(PROP_SHUTDOWN_TIMEOUT, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_SHUTDOWN_TIMEOUT, 5));
        this.defaultConfiguration.put(PROP_RELOAD_TIMEOUT, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_RELOAD_TIMEOUT, 40));
        this.updateConfiguration(null);
        this.configurationListener = bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                try {
                    ((Object)((Object)OsgiManager.this)).getClass().getClassLoader().loadClass("org.osgi.service.metatype.MetaTypeProvider");
                    return new ConfigurationMetatypeSupport(OsgiManager.this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return new ConfigurationSupport(OsgiManager.this);
                }
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("service.vendor", "The Apache Software Foundation");
                this.put("service.description", "OSGi Management Console Configuration Receiver");
                this.put("service.pid", OsgiManager.this.getConfigurationPid());
            }
        });
    }

    public OsgiManagerPlugin createInternalPlugin(String pluginClassName) {
        try {
            Class<?> pluginClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(pluginClassName);
            Object plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (plugin instanceof OsgiManagerPlugin) {
                OsgiManagerPlugin p = (OsgiManagerPlugin)plugin;
                return p;
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            Object message = ncdfe.getMessage();
            if (message == null) {
                message = "Class definition not found (NoClassDefFoundError)";
            } else if (((String)message).indexOf(32) < 0) {
                message = "Class " + (String)message + " missing";
            }
            Util.LOGGER.info("{} not enabled. Reason: {}", (Object)pluginClassName, message);
        }
        catch (Throwable t) {
            Util.LOGGER.info("Failed to instantiate plugin: {}. Reason: {}", new Object[]{pluginClassName, t.getMessage(), t});
        }
        return null;
    }

    void updateRegistrationState() {
        if (this.registeredSecurityProviders.containsAll(this.requiredSecurityProviders)) {
            this.registerHttpWhiteboardServices();
        } else {
            Util.LOGGER.info("Not all requirements met for the Web Console. Required security providers: {}. Registered security providers: {}", this.registeredSecurityProviders, this.registeredSecurityProviders);
            this.unregisterHttpWhiteboardServices();
        }
    }

    public void dispose() {
        this.holder.close();
        this.resourceBundleManager.dispose();
        if (this.brandingTracker != null) {
            this.brandingTracker.close();
            this.brandingTracker = null;
        }
        for (OsgiManagerPlugin plugin : this.osgiManagerPlugins) {
            plugin.deactivate();
        }
        this.osgiManagerPlugins.clear();
        this.unregisterHttpWhiteboardServices();
        if (this.configurationListener != null) {
            this.configurationListener.unregister();
            this.configurationListener = null;
        }
        if (this.securityProviderTracker != null) {
            this.securityProviderTracker.close();
            this.securityProviderTracker = null;
        }
        this.bundleContext = null;
    }

    public void init() {
        this.holder.setServletContext(this.getServletContext());
    }

    public void service(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(req){

                        public String getServletPath() {
                            return "";
                        }

                        public String getPathInfo() {
                            return super.getServletPath();
                        }
                    };
                    OsgiManager.this.doService((HttpServletRequest)wrapper, res);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception x = e.getException();
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (x instanceof ServletException) {
                throw (ServletException)((Object)x);
            }
            throw new IOException(x.toString());
        }
    }

    private void ensureLocaleCookieSet(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        Cookie[] cookies = request.getCookies();
        boolean hasCookie = false;
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!COOKIE_LOCALE.equals(cookies[i].getName())) continue;
            hasCookie = true;
            break;
        }
        if (!hasCookie) {
            Cookie cookie = new Cookie(COOKIE_LOCALE, locale.toString());
            cookie.setPath((String)request.getAttribute("felix.webconsole.appRoot"));
            cookie.setMaxAge(630720000);
            response.addCookie(cookie);
        }
    }

    void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String label;
        Plugin plugin;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/")) {
            String path = request.getRequestURI();
            if (!path.endsWith("/")) {
                path = path.concat("/");
            }
            path = path.concat(this.holder.getDefaultPluginLabel());
            response.setContentLength(0);
            response.sendRedirect(path);
            return;
        }
        Locale locale = this.getConfiguredLocale(request);
        this.initRequest(request, "", locale);
        if (pathInfo.equals("/logout")) {
            this.initRequest(request, "", locale);
            this.logout(request, response);
            return;
        }
        int slash = pathInfo.indexOf("/", 1);
        if (slash < 2) {
            slash = pathInfo.length();
        }
        if ((plugin = this.getConsolePlugin(label = pathInfo.substring(1, slash))) == null) {
            String body404 = MessageFormat.format(this.resourceBundleManager.getResourceBundle(this.bundleContext.getBundle(), locale).getString("404"), request.getContextPath() + request.getServletPath() + "/bundles");
            response.setCharacterEncoding("utf-8");
            response.setContentType("text/html");
            response.setStatus(404);
            response.getWriter().println(body404);
            return;
        }
        this.initRequest(request, "/".concat(label), locale);
        this.ensureLocaleCookieSet(request, response, locale);
        request = this.wrapRequest(request, locale);
        response = this.wrapResponse(request, response, plugin);
        plugin.getConsolePlugin().service((ServletRequest)request, (ServletResponse)response);
    }

    private void initRequest(HttpServletRequest request, String postfix, Locale locale) {
        Map labelMap = this.holder.getLocalizedLabelMap(this.resourceBundleManager, locale, this.defaultCategory);
        Object flatLabelMap = labelMap.remove(PluginHolder.ATTR_FLAT_LABEL_MAP);
        request.setAttribute("felix.webconsole.langMap", this.getLangMap());
        request.setAttribute("felix.webconsole.labelMap", flatLabelMap);
        request.setAttribute("felix.webconsole.labelMap.categorized", (Object)labelMap);
        String appRoot = request.getContextPath().concat(request.getServletPath());
        request.setAttribute("felix.webconsole.appRoot", (Object)appRoot);
        request.setAttribute("felix.webconsole.pluginRoot", (Object)appRoot.concat(postfix));
        request.setAttribute("felix.webconsole.configuration", this.configuration);
        DefaultVariableResolver resolver = new DefaultVariableResolver();
        request.setAttribute("felix.webconsole.variable.resolver", (Object)resolver);
        resolver.put("appRoot", (String)request.getAttribute("felix.webconsole.appRoot"));
        resolver.put("pluginRoot", (String)request.getAttribute("felix.webconsole.pluginRoot"));
    }

    private final void logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SecurityProvider securityProvider = (SecurityProvider)this.securityProviderTracker.getService();
        securityProvider.logout(request, response);
        if (!response.isCommitted()) {
            Cookie[] cookies = request.getCookies();
            boolean found = false;
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (!c.getName().equals("logout")) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                String url = request.getRequestURI();
                int lastSlash = url.lastIndexOf(47);
                Cookie c = new Cookie("logout", "true");
                c.setMaxAge(0);
                response.addCookie(c);
                response.sendRedirect(url.substring(0, lastSlash));
            } else {
                String auth = request.getHeader(HEADER_AUTHORIZATION);
                if (null != auth && auth.toLowerCase().startsWith("basic ")) {
                    Map<String, Object> config = this.getConfiguration();
                    String realm = ConfigurationUtil.getProperty(config, PROP_REALM, DEFAULT_REALM);
                    response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + realm + "\"");
                    response.addCookie(new Cookie("logout", "true"));
                    response.setStatus(401);
                }
            }
        }
        request.removeAttribute("org.osgi.service.http.authentication.remote.user");
        request.removeAttribute("org.osgi.service.useradmin.authorization");
        request.removeAttribute(org.apache.felix.webconsole.servlet.User.USER_ATTRIBUTE);
        request.removeAttribute("org.apache.felix.webconsole.user");
        request.removeAttribute(User.USER_ATTRIBUTE);
    }

    private final Plugin getConsolePlugin(String label) {
        if ("install".equals(label)) {
            return this.holder.getPlugin(DEFAULT_PAGE);
        }
        Plugin plugin = this.holder.getPlugin(label);
        if (plugin == null && label.indexOf(46) > 0) {
            int last = 0;
            int dot = label.indexOf(46, last);
            while (plugin == null && dot > last) {
                String pluginLabel = label.substring(0, dot);
                plugin = this.holder.getPlugin(pluginLabel);
                last = dot + 1;
                dot = label.indexOf(46, last);
            }
        }
        return plugin;
    }

    private final Locale getConfiguredLocale(HttpServletRequest request) {
        Locale locale = null;
        Cookie[] cookies = request.getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!COOKIE_LOCALE.equals(cookies[i].getName())) continue;
            locale = Util.parseLocaleString(cookies[i].getValue());
            break;
        }
        if (locale == null) {
            locale = this.configuredLocale;
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public void destroy() {
        this.holder.setServletContext(null);
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    String getConfigurationPid() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request, final Locale locale) {
        return new HttpServletRequestWrapper(request){

            public Locale getLocale() {
                return locale;
            }
        };
    }

    private HttpServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response, Plugin plugin) {
        Locale locale = request.getLocale();
        ResourceBundle resourceBundle = this.resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
        return new FilteringResponseWrapper(response, resourceBundle, (ServletRequest)request);
    }

    synchronized void registerHttpWhiteboardServices() {
        String realm;
        BasicWebConsoleSecurityProvider.REALM = realm = ConfigurationUtil.getProperty(this.getConfiguration(), PROP_REALM, DEFAULT_REALM);
        try {
            String httpServiceSelector = ConfigurationUtil.getProperty(this.getConfiguration(), PROP_HTTP_SERVICE_SELECTOR, null);
            if (this.basicSecurityServiceRegistration == null) {
                String userId = ConfigurationUtil.getProperty(this.getConfiguration(), PROP_USER_NAME, DEFAULT_USER_NAME);
                String password = ConfigurationUtil.getProperty(this.getConfiguration(), PROP_PASSWORD, DEFAULT_PASSWORD);
                BasicWebConsoleSecurityProvider service = new BasicWebConsoleSecurityProvider(this.bundleContext, userId, password);
                Hashtable<String, Integer> serviceProperties = new Hashtable<String, Integer>();
                ((Dictionary)serviceProperties).put("service.ranking", Integer.MIN_VALUE);
                this.basicSecurityServiceRegistration = this.bundleContext.registerService(SecurityProvider.class, (Object)service, serviceProperties);
            }
            if (this.servletContextRegistration == null) {
                OsgiManagerHttpContext httpContext = new OsgiManagerHttpContext(this.bundleContext.getBundle(), this.securityProviderTracker, this.webManagerRoot);
                Hashtable<String, String> props = new Hashtable<String, String>();
                if (httpServiceSelector != null) {
                    ((Dictionary)props).put("osgi.http.whiteboard.target", httpServiceSelector);
                }
                ((Dictionary)props).put("osgi.http.whiteboard.context.name", SERVLEXT_CONTEXT_NAME);
                ((Dictionary)props).put("osgi.http.whiteboard.context.path", this.webManagerRoot);
                this.servletContextRegistration = this.getBundleContext().registerService(ServletContextHelper.class, (Object)httpContext, props);
            }
            if (this.servletRegistration == null) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                for (Map.Entry<String, Object> entry : this.getConfiguration().entrySet()) {
                    ((Dictionary)props).put(entry.getKey(), String.valueOf(entry.getValue()));
                }
                if (httpServiceSelector != null) {
                    ((Dictionary)props).put("osgi.http.whiteboard.target", httpServiceSelector);
                }
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.multipart.enabled", Boolean.TRUE);
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.multipart.maxFileCount", 50);
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/");
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=org.apache.felix.webconsole)");
                ((Dictionary)props).put("osgi.http.whiteboard.resource.pattern", "/res/*");
                ((Dictionary)props).put("osgi.http.whiteboard.resource.prefix", "/res");
                this.servletRegistration = this.getBundleContext().registerService(Servlet.class, (Object)this, props);
            }
        }
        catch (Exception e) {
            Util.LOGGER.error("registerHttpWhiteboardServices: Problem setting up", (Throwable)e);
            this.unregisterHttpWhiteboardServices();
        }
    }

    synchronized void unregisterHttpWhiteboardServices() {
        if (this.basicSecurityServiceRegistration != null) {
            try {
                this.basicSecurityServiceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.basicSecurityServiceRegistration = null;
        }
        if (this.servletRegistration != null) {
            try {
                this.servletRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.servletRegistration = null;
        }
        if (this.servletContextRegistration != null) {
            try {
                this.servletContextRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.servletContextRegistration = null;
        }
    }

    private Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    Map<String, Object> getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    synchronized void updateConfiguration(Dictionary<String, ?> osgiConfig) {
        boolean enableHeuristics;
        HashMap<String, Object> config = new HashMap<String, Object>(this.defaultConfiguration);
        if (osgiConfig != null) {
            Enumeration<String> keys = osgiConfig.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                config.put(key, osgiConfig.get(key));
            }
        }
        this.configuration = config;
        Object locale = config.get(PROP_LOCALE);
        this.configuredLocale = locale == null || locale.toString().trim().length() == 0 ? null : Util.parseLocaleString(locale.toString().trim());
        this.holder.setDefaultPluginLabel(ConfigurationUtil.getProperty(config, PROP_DEFAULT_RENDER, DEFAULT_PAGE));
        String newWebManagerRoot = ConfigurationUtil.getProperty(config, PROP_MANAGER_ROOT, DEFAULT_MANAGER_ROOT);
        if (!newWebManagerRoot.startsWith("/")) {
            newWebManagerRoot = "/".concat(newWebManagerRoot);
        }
        this.defaultCategory = ConfigurationUtil.getProperty(config, PROP_CATEGORY, DEFAULT_CATEGORY);
        ENABLE_SECRET_HEURISTICS = enableHeuristics = ConfigurationUtil.getProperty(config, PROP_ENABLE_SECRET_HEURISTIC, false);
        String[] plugins = ConfigurationUtil.getStringArrayProperty(config, PROP_ENABLED_PLUGINS);
        HashSet<String> enabledPlugins = null == plugins ? null : new HashSet<String>(Arrays.asList(plugins));
        this.holder.initInternalPlugins(enabledPlugins, this.bundleContext);
        this.unregisterHttpWhiteboardServices();
        this.webManagerRoot = newWebManagerRoot;
        this.registerHttpWhiteboardServices();
    }

    static Set<String> splitCommaSeparatedString(String str) {
        if (str == null) {
            return Collections.emptySet();
        }
        HashSet<String> values = new HashSet<String>();
        for (String s : str.split(",")) {
            String trimmed = s.trim();
            if (trimmed.length() <= 0) continue;
            values.add(trimmed);
        }
        return Collections.unmodifiableSet(values);
    }

    private final Map<String, String> getLangMap() {
        if (null != this.langMap) {
            return this.langMap;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Bundle bundle = this.bundleContext.getBundle();
        Enumeration e = bundle.findEntries("res/flags", null, false);
        while (e != null && e.hasMoreElements()) {
            URL img = (URL)e.nextElement();
            String path = img.getPath();
            try {
                int lastSlash = path.lastIndexOf(47);
                int dot = path.indexOf(46, lastSlash);
                String name = dot == -1 ? path.substring(lastSlash + 1) : path.substring(lastSlash + 1, dot);
                String locale = new Locale(name, "").getDisplayLanguage();
                map.put(name, null != locale ? locale : name);
            }
            catch (Throwable throwable) {}
        }
        this.langMap = map;
        return this.langMap;
    }

    class UpdateDependenciesStateCustomizer
    implements ServiceTrackerCustomizer<SecurityProvider, SecurityProvider> {
        private final Map<Long, String> registeredProviders = new ConcurrentHashMap<Long, String>();

        UpdateDependenciesStateCustomizer() {
        }

        public SecurityProvider addingService(ServiceReference<SecurityProvider> reference) {
            Object nameObj;
            SecurityProvider provider = (SecurityProvider)OsgiManager.this.bundleContext.getService(reference);
            if (provider != null && (nameObj = reference.getProperty("webconsole.security.provider.id")) instanceof String) {
                String name = (String)nameObj;
                Long id = (Long)reference.getProperty("service.id");
                this.registeredProviders.put(id, name);
                OsgiManager.this.registeredSecurityProviders.add(name);
                OsgiManager.this.updateRegistrationState();
            }
            return provider;
        }

        public void modifiedService(ServiceReference<SecurityProvider> reference, SecurityProvider service) {
            this.removedService(reference, service);
            this.addingService((ServiceReference)reference);
        }

        public void removedService(ServiceReference<SecurityProvider> reference, SecurityProvider service) {
            String name = this.registeredProviders.remove(reference.getProperty("service.id"));
            if (name != null) {
                OsgiManager.this.registeredSecurityProviders.remove(name);
                OsgiManager.this.updateRegistrationState();
            }
            try {
                OsgiManager.this.bundleContext.ungetService(reference);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private static class BrandingPluginAdapter
    implements BrandingPlugin {
        private final org.apache.felix.webconsole.spi.BrandingPlugin p;

        public BrandingPluginAdapter(org.apache.felix.webconsole.spi.BrandingPlugin p) {
            this.p = p;
        }

        @Override
        public String getBrandName() {
            return this.p.getBrandName();
        }

        @Override
        public String getFavIcon() {
            return this.p.getFavIcon();
        }

        @Override
        public String getMainStyleSheet() {
            return this.p.getMainStyleSheet();
        }

        @Override
        public String getProductImage() {
            return this.p.getProductImage();
        }

        @Override
        public String getProductName() {
            return this.p.getProductName();
        }

        @Override
        public String getProductURL() {
            return this.p.getProductURL();
        }

        @Override
        public String getVendorImage() {
            return this.p.getVendorImage();
        }

        @Override
        public String getVendorName() {
            return this.p.getVendorName();
        }

        @Override
        public String getVendorURL() {
            return this.p.getVendorURL();
        }
    }

    private static class BrandingServiceTracker
    extends ServiceTracker<org.apache.felix.webconsole.spi.BrandingPlugin, org.apache.felix.webconsole.spi.BrandingPlugin> {
        private static Filter createFilter(BundleContext context) {
            try {
                Filter filter = context.createFilter("(|(objectClass=" + org.apache.felix.webconsole.spi.BrandingPlugin.class.getName() + ")(objectClass=" + BrandingPlugin.class.getName() + "))");
                return filter;
            }
            catch (InvalidSyntaxException e) {
                throw new InternalError(e);
            }
        }

        public BrandingServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), BrandingServiceTracker.createFilter(osgiManager.getBundleContext()), null);
        }

        public org.apache.felix.webconsole.spi.BrandingPlugin addingService(ServiceReference<org.apache.felix.webconsole.spi.BrandingPlugin> reference) {
            org.apache.felix.webconsole.spi.BrandingPlugin plugin = (org.apache.felix.webconsole.spi.BrandingPlugin)super.addingService(reference);
            if (plugin != null) {
                if (plugin instanceof BrandingPlugin) {
                    AbstractWebConsolePlugin.setBrandingPlugin((BrandingPlugin)plugin);
                } else {
                    AbstractWebConsolePlugin.setBrandingPlugin(new BrandingPluginAdapter(plugin));
                }
                AbstractPluginAdapter.setBrandingPlugin(plugin);
            }
            return plugin;
        }

        public void removedService(ServiceReference<org.apache.felix.webconsole.spi.BrandingPlugin> reference, org.apache.felix.webconsole.spi.BrandingPlugin service) {
            AbstractWebConsolePlugin.setBrandingPlugin(null);
            AbstractPluginAdapter.setBrandingPlugin(null);
            try {
                super.removedService(reference, (Object)service);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

