/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.internal.core.BundleContextUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.startlevel.StartLevel;

abstract class BaseUpdateInstallHelper
implements Runnable {
    private final SimpleWebConsolePlugin plugin;
    private final File bundleFile;
    private final boolean refreshPackages;
    private Thread updateThread;

    BaseUpdateInstallHelper(SimpleWebConsolePlugin plugin, String name, File bundleFile, boolean refreshPackages) {
        this.plugin = plugin;
        this.bundleFile = bundleFile;
        this.refreshPackages = refreshPackages;
        this.updateThread = new Thread((Runnable)this, name);
        this.updateThread.setDaemon(true);
    }

    protected File getBundleFile() {
        return this.bundleFile;
    }

    protected abstract Bundle doRun(InputStream var1) throws BundleException;

    protected final Object getService(String serviceName) {
        return this.plugin.getService(serviceName);
    }

    protected final SimpleWebConsolePlugin getLog() {
        return this.plugin;
    }

    protected Bundle getTargetBundle() {
        return null;
    }

    protected Bundle doRun() throws Exception {
        Bundle bundle;
        FileInputStream bundleStream = null;
        try {
            bundleStream = new FileInputStream(this.bundleFile);
            bundle = this.doRun(bundleStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bundleStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bundleStream);
        return bundle;
    }

    final void start() {
        if (this.updateThread != null) {
            this.updateThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            FrameworkWiring fw = this.refreshPackages ? (FrameworkWiring)this.plugin.getBundle().getBundleContext().getBundle("System Bundle").adapt(FrameworkWiring.class) : null;
            StartLevel startLevel = null;
            Bundle bundle = this.getTargetBundle();
            int state = fw != null && bundle != null ? bundle.getState() : 0;
            int startFlags = 0;
            if ((state & 0x28) != 0) {
                startLevel = (StartLevel)this.getService(StartLevel.class.getName());
                if (startLevel == null || startLevel.getStartLevel() >= startLevel.getBundleStartLevel(bundle)) {
                    startFlags |= 1;
                }
                if (state == 8) {
                    startFlags |= 2;
                }
                bundle.stop(1);
            }
            Exception rethrow = null;
            try {
                bundle = this.doRun();
                if (bundle != null) {
                    BaseUpdateInstallHelper.refreshPackages(fw, this.plugin.getBundle().getBundleContext(), 5000L, bundle);
                }
            }
            catch (Exception ex) {
                rethrow = ex;
                throw ex;
            }
            finally {
                if ((state & 0x28) != 0) {
                    try {
                        bundle.start(startFlags);
                    }
                    catch (Exception ex) {
                        if (rethrow == null) {
                            throw ex;
                        }
                        try {
                            this.getLog().log(1, "Cannot restart bundle: " + bundle + " after exception during update!", ex);
                        }
                        catch (Exception secondary) {
                            System.err.println("Cannot restart bundle: " + bundle + " after exception during update!");
                            ex.printStackTrace(System.err);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                this.getLog().log(1, "Cannot install or update bundle from " + this.bundleFile, e);
            }
            catch (Exception secondary) {
                System.err.println("Cannot install or update bundle from " + this.bundleFile);
                e.printStackTrace(System.err);
            }
        }
        finally {
            if (this.bundleFile != null) {
                this.bundleFile.delete();
            }
            this.updateThread = null;
        }
    }

    static boolean refreshPackages(FrameworkWiring fw, BundleContext bundleContext, long maxWait, Bundle bundle) {
        return new RefreshPackageTask().refreshPackages(fw, bundleContext, maxWait, bundle);
    }

    static class RefreshPackageTask
    implements FrameworkListener {
        private volatile boolean refreshed = false;
        private final Object lock = new Object();

        RefreshPackageTask() {
        }

        private Bundle searchHost(BundleContext bundleContext, Bundle bundle) {
            String host = (String)bundle.getHeaders().get("Fragment-Host");
            if (host != null && host.indexOf("extension") == -1) {
                for (Bundle i : BundleContextUtil.getWorkingBundleContext(bundleContext).getBundles()) {
                    if (!host.equals(i.getSymbolicName())) continue;
                    return i;
                }
            }
            return null;
        }

        boolean refreshPackages(FrameworkWiring fw, BundleContext bundleContext, long maxWait, Bundle bundle) {
            ArrayList<Bundle> refreshFragments = null;
            if (null == bundleContext || fw == null) {
                return false;
            }
            if (null == bundle) {
                refreshFragments = new ArrayList<Bundle>();
                for (Bundle i : BundleContextUtil.getWorkingBundleContext(bundleContext).getBundles()) {
                    Bundle hostBundle;
                    if (i.getState() == 4 || (hostBundle = this.searchHost(bundleContext, i)) == null) continue;
                    refreshFragments.add(hostBundle);
                }
                if (refreshFragments.isEmpty()) {
                    refreshFragments = null;
                }
                fw.refreshBundles(null, new FrameworkListener[]{this});
            } else {
                Bundle hostBundle = this.searchHost(bundleContext, bundle);
                if (hostBundle != null) {
                    bundle = hostBundle;
                }
                fw.refreshBundles(Collections.singleton(bundle), new FrameworkListener[]{this});
            }
            this.waitForRefresh(maxWait);
            if (refreshFragments != null) {
                Iterator iter = refreshFragments.iterator();
                while (iter.hasNext()) {
                    if (((Bundle)iter.next()).getState() != 1) continue;
                    iter.remove();
                }
                if (!refreshFragments.isEmpty()) {
                    this.refreshed = false;
                    fw.refreshBundles(refreshFragments, new FrameworkListener[]{this});
                    this.waitForRefresh(maxWait);
                }
            }
            return this.refreshed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitForRefresh(long maxWait) {
            try {
                long start = System.currentTimeMillis();
                long delay = maxWait;
                while (!this.refreshed && delay > 0L) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.refreshed) {
                            this.lock.wait(delay);
                            delay = maxWait - (System.currentTimeMillis() - start);
                        }
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void frameworkEvent(FrameworkEvent e) {
            if (e.getType() == 4) {
                Object object = this.lock;
                synchronized (object) {
                    this.refreshed = true;
                    this.lock.notifyAll();
                }
            }
        }
    }
}

