/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;

public class LogServlet
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final String LABEL = "logs";
    private static final String TITLE = "%logs.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/logs.css"};
    private static final int MAX_LOGS = 200;
    private final String TEMPLATE = this.readTemplateFile("/templates/logs.html");
    static /* synthetic */ Class class$org$osgi$service$log$LogReaderService;

    public LogServlet() {
        super(LABEL, TITLE, CSS);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int minLevel = WebConsoleUtil.getParameterInt(req, "minLevel", 4);
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        this.renderJSON(resp.getWriter(), minLevel);
    }

    private final void renderJSON(PrintWriter pw, int minLogLevel) throws IOException {
        LogReaderService logReaderService = (LogReaderService)this.getService((class$org$osgi$service$log$LogReaderService == null ? (class$org$osgi$service$log$LogReaderService = LogServlet.class$("org.osgi.service.log.LogReaderService")) : class$org$osgi$service$log$LogReaderService).getName());
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            jw.key("status");
            jw.value((Object)(logReaderService == null ? Boolean.FALSE : Boolean.TRUE));
            jw.key("data");
            jw.array();
            if (logReaderService != null) {
                int index = 0;
                Enumeration logEntries = logReaderService.getLog();
                while (logEntries.hasMoreElements() && index < 200) {
                    LogEntry nextLog = (LogEntry)logEntries.nextElement();
                    if (nextLog.getLevel() > minLogLevel) continue;
                    LogServlet.logJson(jw, nextLog, index++);
                }
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int minLevel = WebConsoleUtil.getParameterInt(request, "minLevel", 4);
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            this.renderJSON(pw, minLevel);
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().print(this.TEMPLATE);
    }

    private static final void logJson(JSONWriter jw, LogEntry info, int index) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value((Object)String.valueOf(index));
        jw.key("received");
        jw.value(info.getTime());
        jw.key("level");
        jw.value((Object)LogServlet.logLevel(info.getLevel()));
        jw.key("raw_level");
        jw.value((long)info.getLevel());
        jw.key("message");
        jw.value((Object)info.getMessage());
        jw.key("service");
        jw.value((Object)LogServlet.serviceDescription(info.getServiceReference()));
        jw.key("exception");
        jw.value((Object)LogServlet.exceptionMessage(info.getException()));
        jw.endObject();
    }

    private static final String serviceDescription(ServiceReference serviceReference) {
        if (serviceReference == null) {
            return "";
        }
        return serviceReference.toString();
    }

    private static final String logLevel(int level) {
        switch (level) {
            case 3: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "DEBUG";
    }

    private static final String exceptionMessage(Throwable e) {
        if (e == null) {
            return "";
        }
        return e.getClass().getName() + ": " + e.getMessage();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

