/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.misc.ConfigurationRender;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationAdminConfigurationPrinter
extends AbstractConfigurationPrinter {
    public static final String TITLE = "Configurations";
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;

    public String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printConfiguration(PrintWriter pw) {
        ServiceReference sr = this.getBundleContext().getServiceReference((class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = ConfigurationAdminConfigurationPrinter.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName());
        if (sr == null) {
            pw.println("  Configuration Admin Service not registered");
        } else {
            ConfigurationAdmin ca = (ConfigurationAdmin)this.getBundleContext().getService(sr);
            try {
                Configuration[] configs = ca.listConfigurations(null);
                if (configs != null && configs.length > 0) {
                    TreeMap<String, Configuration> sm = new TreeMap<String, Configuration>();
                    for (int i = 0; i < configs.length; ++i) {
                        sm.put(configs[i].getPid(), configs[i]);
                    }
                    Iterator mi = sm.values().iterator();
                    while (mi.hasNext()) {
                        this.printConfiguration(pw, (Configuration)mi.next());
                    }
                } else {
                    pw.println("  No Configurations available");
                }
            }
            catch (Exception e) {
            }
            finally {
                this.getBundleContext().ungetService(sr);
            }
        }
    }

    private void printConfiguration(PrintWriter pw, Configuration config) {
        ConfigurationRender.infoLine(pw, "", "PID", config.getPid());
        if (config.getFactoryPid() != null) {
            ConfigurationRender.infoLine(pw, "  ", "Factory PID", config.getFactoryPid());
        }
        String loc = config.getBundleLocation() != null ? config.getBundleLocation() : "Unbound";
        ConfigurationRender.infoLine(pw, "  ", "BundleLocation", loc);
        Dictionary props = config.getProperties();
        if (props != null) {
            TreeSet keys = new TreeSet();
            Enumeration ke = props.keys();
            while (ke.hasMoreElements()) {
                keys.add(ke.nextElement());
            }
            Iterator ki = keys.iterator();
            while (ki.hasNext()) {
                String key = (String)ki.next();
                ConfigurationRender.infoLine(pw, "  ", key, props.get(key));
            }
        }
        pw.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

