/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.felix.webconsole.Action;
import org.apache.felix.webconsole.Render;
import org.apache.felix.webconsole.internal.BaseManagementPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.servlet.ConfigurationListener;
import org.apache.felix.webconsole.internal.servlet.Logger;
import org.apache.felix.webconsole.internal.servlet.OsgiManagerHttpContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiManager
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_NO_REDIRECT_AFTER_ACTION = "_noredir_";
    private static final String PROP_MANAGER_ROOT = "manager.root";
    private static final String PROP_DEFAULT_RENDER = "default.render";
    private static final String PROP_REALM = "realm";
    private static final String PROP_USER_NAME = "username";
    private static final String PROP_PASSWORD = "password";
    private static final String DEFAULT_MANAGER_ROOT = "/system/console";
    private static final Class[] PLUGIN_CLASSES = new Class[]{class$org$apache$felix$webconsole$internal$compendium$AjaxConfigManagerAction == null ? (class$org$apache$felix$webconsole$internal$compendium$AjaxConfigManagerAction = OsgiManager.class$("org.apache.felix.webconsole.internal.compendium.AjaxConfigManagerAction")) : class$org$apache$felix$webconsole$internal$compendium$AjaxConfigManagerAction, class$org$apache$felix$webconsole$internal$compendium$ComponentConfigurationPrinter == null ? (class$org$apache$felix$webconsole$internal$compendium$ComponentConfigurationPrinter = OsgiManager.class$("org.apache.felix.webconsole.internal.compendium.ComponentConfigurationPrinter")) : class$org$apache$felix$webconsole$internal$compendium$ComponentConfigurationPrinter, class$org$apache$felix$webconsole$internal$compendium$ComponentRenderAction == null ? (class$org$apache$felix$webconsole$internal$compendium$ComponentRenderAction = OsgiManager.class$("org.apache.felix.webconsole.internal.compendium.ComponentRenderAction")) : class$org$apache$felix$webconsole$internal$compendium$ComponentRenderAction, class$org$apache$felix$webconsole$internal$compendium$ConfigManager == null ? (class$org$apache$felix$webconsole$internal$compendium$ConfigManager = OsgiManager.class$("org.apache.felix.webconsole.internal.compendium.ConfigManager")) : class$org$apache$felix$webconsole$internal$compendium$ConfigManager, class$org$apache$felix$webconsole$internal$core$AjaxBundleDetailsAction == null ? (class$org$apache$felix$webconsole$internal$core$AjaxBundleDetailsAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.AjaxBundleDetailsAction")) : class$org$apache$felix$webconsole$internal$core$AjaxBundleDetailsAction, class$org$apache$felix$webconsole$internal$core$BundleListRender == null ? (class$org$apache$felix$webconsole$internal$core$BundleListRender = OsgiManager.class$("org.apache.felix.webconsole.internal.core.BundleListRender")) : class$org$apache$felix$webconsole$internal$core$BundleListRender, class$org$apache$felix$webconsole$internal$core$InstallAction == null ? (class$org$apache$felix$webconsole$internal$core$InstallAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.InstallAction")) : class$org$apache$felix$webconsole$internal$core$InstallAction, class$org$apache$felix$webconsole$internal$core$RefreshPackagesAction == null ? (class$org$apache$felix$webconsole$internal$core$RefreshPackagesAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.RefreshPackagesAction")) : class$org$apache$felix$webconsole$internal$core$RefreshPackagesAction, class$org$apache$felix$webconsole$internal$core$SetStartLevelAction == null ? (class$org$apache$felix$webconsole$internal$core$SetStartLevelAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.SetStartLevelAction")) : class$org$apache$felix$webconsole$internal$core$SetStartLevelAction, class$org$apache$felix$webconsole$internal$core$StartAction == null ? (class$org$apache$felix$webconsole$internal$core$StartAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.StartAction")) : class$org$apache$felix$webconsole$internal$core$StartAction, class$org$apache$felix$webconsole$internal$core$StopAction == null ? (class$org$apache$felix$webconsole$internal$core$StopAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.StopAction")) : class$org$apache$felix$webconsole$internal$core$StopAction, class$org$apache$felix$webconsole$internal$core$UninstallAction == null ? (class$org$apache$felix$webconsole$internal$core$UninstallAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.UninstallAction")) : class$org$apache$felix$webconsole$internal$core$UninstallAction, class$org$apache$felix$webconsole$internal$core$UpdateAction == null ? (class$org$apache$felix$webconsole$internal$core$UpdateAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.UpdateAction")) : class$org$apache$felix$webconsole$internal$core$UpdateAction, class$org$apache$felix$webconsole$internal$misc$ConfigurationRender == null ? (class$org$apache$felix$webconsole$internal$misc$ConfigurationRender = OsgiManager.class$("org.apache.felix.webconsole.internal.misc.ConfigurationRender")) : class$org$apache$felix$webconsole$internal$misc$ConfigurationRender, class$org$apache$felix$webconsole$internal$system$GCAction == null ? (class$org$apache$felix$webconsole$internal$system$GCAction = OsgiManager.class$("org.apache.felix.webconsole.internal.system.GCAction")) : class$org$apache$felix$webconsole$internal$system$GCAction, class$org$apache$felix$webconsole$internal$system$ShutdownAction == null ? (class$org$apache$felix$webconsole$internal$system$ShutdownAction = OsgiManager.class$("org.apache.felix.webconsole.internal.system.ShutdownAction")) : class$org$apache$felix$webconsole$internal$system$ShutdownAction, class$org$apache$felix$webconsole$internal$system$ShutdownRender == null ? (class$org$apache$felix$webconsole$internal$system$ShutdownRender = OsgiManager.class$("org.apache.felix.webconsole.internal.system.ShutdownRender")) : class$org$apache$felix$webconsole$internal$system$ShutdownRender, class$org$apache$felix$webconsole$internal$system$VMStatRender == null ? (class$org$apache$felix$webconsole$internal$system$VMStatRender = OsgiManager.class$("org.apache.felix.webconsole.internal.system.VMStatRender")) : class$org$apache$felix$webconsole$internal$system$VMStatRender};
    private BundleContext bundleContext;
    private Logger log;
    private ServiceTracker httpServiceTracker;
    private HttpService httpService;
    private ServiceTracker operationsTracker;
    private ServiceTracker rendersTracker;
    private ServiceRegistration configurationListener;
    private Map operations = new HashMap();
    private SortedMap renders = new TreeMap();
    private Render defaultRender;
    private String defaultRenderName;
    private String webManagerRoot;
    private Dictionary configuration;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$compendium$AjaxConfigManagerAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$compendium$ComponentConfigurationPrinter;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$compendium$ComponentRenderAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$compendium$ConfigManager;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$AjaxBundleDetailsAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$BundleListRender;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$InstallAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$RefreshPackagesAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$SetStartLevelAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$StartAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$StopAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$UninstallAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$UpdateAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$misc$ConfigurationRender;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$system$GCAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$system$ShutdownAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$system$ShutdownRender;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$system$VMStatRender;
    static /* synthetic */ Class class$org$osgi$service$http$HttpService;

    public OsgiManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.log = new Logger(bundleContext);
        this.updateConfiguration(null);
        try {
            this.configurationListener = ConfigurationListener.create(this);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.operationsTracker = new OperationServiceTracker(this);
        this.operationsTracker.open();
        this.rendersTracker = new RenderServiceTracker(this);
        this.rendersTracker.open();
        this.httpServiceTracker = new HttpServiceTracker(this);
        this.httpServiceTracker.open();
        for (int i = 0; i < PLUGIN_CLASSES.length; ++i) {
            Class pluginClass = PLUGIN_CLASSES[i];
            try {
                Object plugin = pluginClass.newInstance();
                if (plugin instanceof BaseManagementPlugin) {
                    ((BaseManagementPlugin)plugin).setBundleContext(bundleContext);
                    ((BaseManagementPlugin)plugin).setLogger(this.log);
                }
                if (plugin instanceof Action) {
                    this.bindOperation((Action)plugin);
                }
                if (!(plugin instanceof Render)) continue;
                this.bindRender((Render)plugin);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        if (this.configurationListener != null) {
            this.configurationListener.unregister();
            this.configurationListener = null;
        }
        if (this.operationsTracker != null) {
            this.operationsTracker.close();
            this.operationsTracker = null;
        }
        if (this.rendersTracker != null) {
            this.rendersTracker.close();
            this.rendersTracker = null;
        }
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        this.defaultRender = null;
        this.operations.clear();
        this.renders.clear();
        if (this.log != null) {
            this.log.dispose();
        }
        this.bundleContext = null;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.handleAction(request, response)) {
            return;
        }
        if (request.getRequestURI().endsWith(this.webManagerRoot)) {
            response.sendRedirect(request.getRequestURI() + "/" + this.defaultRender.getName());
            return;
        }
        Render render = this.getRender(request);
        if (render == null) {
            response.sendError(404);
            return;
        }
        String current = render.getName();
        boolean disabled = false;
        PrintWriter pw = Util.startHtml(response, render.getLabel());
        Util.navigation(pw, this.renders.values(), current, disabled);
        render.render(request, response);
        Util.endHhtml(pw);
    }

    protected boolean handleAction(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Action action;
        String actionName = this.getParameter(req, "action");
        if (actionName != null && (action = (Action)this.operations.get(actionName)) != null) {
            boolean redirect = true;
            try {
                redirect = action.performAction(req, resp);
            }
            catch (IOException ioe) {
                this.log(ioe.getMessage(), ioe);
            }
            catch (ServletException se) {
                this.log(se.getMessage(), se.getRootCause());
            }
            if (PARAM_NO_REDIRECT_AFTER_ACTION.equals(this.getParameter(req, PARAM_NO_REDIRECT_AFTER_ACTION))) {
                resp.setStatus(200);
                resp.setContentType("text/html");
                resp.getWriter().println("Ok");
                return true;
            }
            if (redirect) {
                String uri = req.getRequestURI();
                resp.sendRedirect(uri);
            }
            return true;
        }
        return false;
    }

    protected Render getRender(HttpServletRequest request) {
        Render render;
        String page = request.getRequestURI();
        while (page.endsWith("/")) {
            page = page.substring(0, page.length() - 1);
        }
        int lastSlash = page.lastIndexOf(47);
        if (lastSlash >= 0) {
            page = page.substring(lastSlash + 1);
        }
        return (render = (Render)this.renders.get(page)) == null ? this.defaultRender : render;
    }

    private String getParameter(HttpServletRequest request, String name) {
        FileItem[] param;
        if (!ServletFileUpload.isMultipartContent(new ServletRequestContext(request))) {
            return request.getParameter(name);
        }
        HashMap<String, FileItem[]> params = (HashMap<String, FileItem[]>)request.getAttribute("org.apache.felix.webconsole.fileupload");
        if (params == null) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(256000);
            ServletFileUpload upload = new ServletFileUpload(factory);
            upload.setSizeMax(-1L);
            params = new HashMap<String, FileItem[]>();
            try {
                List items = upload.parseRequest(request);
                Iterator fiter = items.iterator();
                while (fiter.hasNext()) {
                    FileItem fi = (FileItem)fiter.next();
                    FileItem[] current = (FileItem[])params.get(fi.getFieldName());
                    if (current == null) {
                        current = new FileItem[]{fi};
                    } else {
                        FileItem[] newCurrent = new FileItem[current.length + 1];
                        System.arraycopy(current, 0, newCurrent, 0, current.length);
                        newCurrent[current.length] = fi;
                        current = newCurrent;
                    }
                    params.put(fi.getFieldName(), current);
                }
            }
            catch (FileUploadException fue) {
                // empty catch block
            }
            request.setAttribute("org.apache.felix.webconsole.fileupload", params);
        }
        if ((param = (FileItem[])params.get(name)) != null) {
            for (int i = 0; i < param.length; ++i) {
                if (!param[i].isFormField()) continue;
                return param[i].getString();
            }
        }
        return null;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected synchronized void bindHttpService(HttpService httpService) {
        Dictionary config = this.getConfiguration();
        String realm = this.getProperty(config, PROP_REALM, "OSGi Management Console");
        String userId = this.getProperty(config, PROP_USER_NAME, null);
        String password = this.getProperty(config, PROP_PASSWORD, null);
        try {
            OsgiManagerHttpContext httpContext = new OsgiManagerHttpContext(httpService, realm, userId, password);
            Dictionary servletConfig = this.toStringConfig(config);
            httpService.registerServlet(this.webManagerRoot, (Servlet)this, servletConfig, (HttpContext)httpContext);
            httpService.registerResources(this.webManagerRoot + "/res", "/res", (HttpContext)httpContext);
        }
        catch (Exception e) {
            this.log.log(1, "Problem setting up", e);
        }
        this.httpService = httpService;
    }

    protected synchronized void unbindHttpService(HttpService httpService) {
        httpService.unregister(this.webManagerRoot + "/res");
        httpService.unregister(this.webManagerRoot);
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }

    protected void bindOperation(Action operation) {
        this.operations.put(operation.getName(), operation);
    }

    protected void unbindOperation(Action operation) {
        this.operations.remove(operation.getName());
    }

    protected void bindRender(Render render) {
        this.renders.put(render.getName(), render);
        if (this.defaultRender == null) {
            this.defaultRender = render;
        } else if (render.getName().equals(this.defaultRenderName)) {
            this.defaultRender = render;
        }
    }

    protected void unbindRender(Render render) {
        this.renders.remove(render.getName());
        if (this.defaultRender == render) {
            this.defaultRender = this.renders.isEmpty() ? null : (Render)this.renders.values().iterator().next();
        }
    }

    private Dictionary getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfiguration(Dictionary config) {
        HttpService httpService;
        if (config == null) {
            config = new Hashtable();
        }
        this.configuration = config;
        this.defaultRenderName = (String)((Dictionary)config).get(PROP_DEFAULT_RENDER);
        if (this.defaultRenderName != null && this.renders.get(this.defaultRenderName) != null) {
            this.defaultRender = (Render)this.renders.get(this.defaultRenderName);
        }
        this.webManagerRoot = this.getProperty(config, PROP_MANAGER_ROOT, DEFAULT_MANAGER_ROOT);
        if (!this.webManagerRoot.startsWith("/")) {
            this.webManagerRoot = "/" + this.webManagerRoot;
        }
        if ((httpService = this.httpService) != null) {
            OsgiManager osgiManager = this;
            synchronized (osgiManager) {
                this.unbindHttpService(httpService);
                this.bindHttpService(httpService);
            }
        }
    }

    private String getProperty(Dictionary config, String name, String def) {
        Object value = config.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return def;
        }
        return String.valueOf(value);
    }

    private Dictionary toStringConfig(Dictionary config) {
        Hashtable<String, String> stringConfig = new Hashtable<String, String>();
        Enumeration ke = config.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            ((Dictionary)stringConfig).put(key.toString(), String.valueOf(config.get(key)));
        }
        return stringConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RenderServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        RenderServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), Render.SERVICE, null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object operation = super.addingService(reference);
            if (operation instanceof Render) {
                this.osgiManager.bindRender((Render)operation);
            }
            return operation;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof Render) {
                this.osgiManager.bindRender((Render)service);
            }
            super.removedService(reference, service);
        }
    }

    private static class OperationServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        OperationServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), Action.SERVICE, null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object operation = super.addingService(reference);
            if (operation instanceof Action) {
                this.osgiManager.bindOperation((Action)operation);
            }
            return operation;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof Action) {
                this.osgiManager.bindOperation((Action)service);
            }
            super.removedService(reference, service);
        }
    }

    private static class HttpServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        HttpServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), (class$org$osgi$service$http$HttpService == null ? (class$org$osgi$service$http$HttpService = OsgiManager.class$("org.osgi.service.http.HttpService")) : class$org$osgi$service$http$HttpService).getName(), null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object operation = super.addingService(reference);
            if (operation instanceof HttpService) {
                this.osgiManager.bindHttpService((HttpService)operation);
            }
            return operation;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof HttpService) {
                this.osgiManager.unbindHttpService((HttpService)service);
            }
            super.removedService(reference, service);
        }
    }
}

