/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.packageadmin.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.plugins.packageadmin.internal.WebConsolePlugin;
import org.apache.felix.webconsole.plugins.packageadmin.internal.WebConsolePrinter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    private ServiceTracker pkgAdminTracker;
    private BundleContext context;
    private SimpleWebConsolePlugin plugin;
    private ServiceRegistration<InventoryPrinter> printerReg;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.pkgAdminTracker = new ServiceTracker(context, "org.osgi.service.packageadmin.PackageAdmin", (ServiceTrackerCustomizer)this);
        this.pkgAdminTracker.open();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("felix.inventory.printer.name", "duplicate_exports");
        ((Dictionary)props).put("felix.inventory.printer.title", "Duplicate Exports");
        ((Dictionary)props).put("felix.inventory.printer.format", new String[]{Format.TEXT.toString()});
        this.printerReg = context.registerService(InventoryPrinter.class, (Object)new WebConsolePrinter(context, this.pkgAdminTracker), props);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.printerReg != null) {
            this.printerReg.unregister();
            this.printerReg = null;
        }
        if (this.pkgAdminTracker != null) {
            this.pkgAdminTracker.close();
            this.pkgAdminTracker = null;
        }
        this.context = null;
    }

    public final void modifiedService(ServiceReference reference, Object service) {
    }

    public final Object addingService(ServiceReference reference) {
        SimpleWebConsolePlugin plugin = this.plugin;
        Object ret = null;
        if (plugin == null) {
            ret = this.context.getService(reference);
            this.plugin = plugin = new WebConsolePlugin(this.context, ret).register(this.context);
        }
        return ret;
    }

    public final void removedService(ServiceReference reference, Object service) {
        SimpleWebConsolePlugin plugin = this.plugin;
        if (this.pkgAdminTracker.size() <= 1 && plugin != null) {
            plugin.unregister();
            this.plugin = null;
        }
    }
}

