/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.plugins.ds.internal.ComponentConfigurationPrinter;
import org.apache.felix.webconsole.plugins.ds.internal.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

class WebConsolePlugin
extends SimpleWebConsolePlugin {
    private static final long serialVersionUID = 1L;
    private static final String LABEL = "components";
    private static final String TITLE = "%components.pluginTitle";
    private static final String CATEGORY = "OSGi";
    private static final String[] CSS = new String[]{"/res/ui/bundles.css"};
    private static final String RES = "/components/res/";
    private static final String OPERATION = "action";
    private static final String OPERATION_ENABLE = "enable";
    private static final String OPERATION_DISABLE = "disable";
    static final String SCR_SERVICE = ServiceComponentRuntime.class.getName();
    private static final String META_TYPE_NAME = "org.osgi.service.metatype.MetaTypeService";
    private static final String CONFIGURATION_ADMIN_NAME = "org.osgi.service.cm.ConfigurationAdmin";
    private final String TEMPLATE = this.readTemplateFile("/res/plugin.html");

    WebConsolePlugin() {
        super(LABEL, TITLE, CSS);
    }

    public String getCategory() {
        return CATEGORY;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestInfo reqInfo = new RequestInfo(request);
        if (reqInfo.component == null && reqInfo.componentRequested) {
            response.sendError(404);
            return;
        }
        if (!reqInfo.componentRequested) {
            response.sendError(500);
            return;
        }
        String op = request.getParameter(OPERATION);
        if (OPERATION_ENABLE.equals(op)) {
            this.getScrService().enableComponent(reqInfo.component.description);
        } else if (OPERATION_DISABLE.equals(op)) {
            this.getScrService().disableComponent(reqInfo.component.description);
        }
        PrintWriter pw = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        this.renderResult(pw, reqInfo, null);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (!path.startsWith(RES)) {
            RequestInfo reqInfo = new RequestInfo(request);
            if (reqInfo.component == null && reqInfo.componentRequested) {
                response.sendError(404);
                return;
            }
            if (reqInfo.extension.equals("json")) {
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                this.renderResult(response.getWriter(), reqInfo, reqInfo.component);
                return;
            }
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestInfo reqInfo = WebConsolePlugin.getRequestInfo(request);
        StringWriter w = new StringWriter();
        PrintWriter w2 = new PrintWriter(w);
        this.renderResult(w2, reqInfo, reqInfo.component);
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put((Object)"__drawDetails__", (Object)(reqInfo.componentRequested ? Boolean.TRUE : Boolean.FALSE));
        vars.put((Object)"__data__", (Object)w.toString());
        response.getWriter().print(this.TEMPLATE);
    }

    private void renderResult(PrintWriter pw, RequestInfo info, ComponentConfigurationDTO component) throws IOException {
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            ServiceComponentRuntime scrService = this.getScrService();
            if (scrService == null) {
                jw.key("status");
                jw.value(-1L);
            } else if (info.configurations.size() == 0) {
                jw.key("status");
                jw.value(0L);
            } else {
                StringBuffer buffer = new StringBuffer();
                buffer.append(info.configurations.size());
                buffer.append(" component");
                if (info.configurations.size() != 1) {
                    buffer.append('s');
                }
                buffer.append(" installed.");
                jw.key("status");
                jw.value((long)info.configurations.size());
                jw.key("data");
                jw.array();
                if (component != null) {
                    this.component(jw, component, true);
                } else {
                    for (ComponentConfigurationDTO cfg : info.configurations) {
                        this.component(jw, cfg, false);
                    }
                }
                jw.endArray();
            }
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    private void component(JSONWriter jw, ComponentConfigurationDTO component, boolean details) throws JSONException {
        Collection col;
        Object obj;
        String id = String.valueOf(component.id);
        String name = component.description.name;
        int state = component.state;
        jw.object();
        jw.key("id");
        jw.value((Object)id);
        jw.key("name");
        jw.value((Object)name);
        jw.key("state");
        jw.value((Object)ComponentConfigurationPrinter.toStateString(state));
        jw.key("stateRaw");
        jw.value((long)state);
        Map props = component.properties;
        String pid = null;
        Object configurationPid = null;
        Object v0 = obj = props != null ? props.get("service.pid") : null;
        if (obj instanceof String) {
            pid = obj;
            configurationPid = pid;
        } else if (obj instanceof String[]) {
            Object[] arr = obj;
            if (arr.length > 0) {
                pid = Arrays.toString(arr);
                configurationPid = arr[0];
            }
        } else if (obj instanceof Collection && !(col = (Collection)obj).isEmpty()) {
            pid = col.toString();
            configurationPid = col.iterator().next().toString();
        }
        if (pid != null) {
            jw.key("pid");
            jw.value((Object)pid);
            if (configurationPid != null && this.isConfigurable(this.getBundleContext().getBundle(0L).getBundleContext().getBundle(component.description.bundle.id), (String)configurationPid)) {
                jw.key("configurable");
                jw.value(configurationPid);
            }
        }
        if (details) {
            this.gatherComponentDetails(jw, component);
        }
        jw.endObject();
    }

    private void gatherComponentDetails(JSONWriter jw, ComponentConfigurationDTO component) throws JSONException {
        Bundle bundle = this.getBundleContext().getBundle(0L).getBundleContext().getBundle(component.description.bundle.id);
        jw.key("props");
        jw.array();
        this.keyVal(jw, "Bundle", bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")");
        this.keyVal(jw, "Implementation Class", component.description.implementationClass);
        if (component.description.factory != null) {
            this.keyVal(jw, "Component Factory Name", component.description.factory);
        }
        this.keyVal(jw, "Default State", component.description.defaultEnabled ? "enabled" : "disabled");
        this.keyVal(jw, "Activation", component.description.immediate ? "immediate" : "delayed");
        try {
            this.keyVal(jw, "Configuration Policy", component.description.configurationPolicy);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.listServices(jw, component);
        this.listReferences(jw, component);
        this.listProperties(jw, component);
        jw.endArray();
    }

    private void listServices(JSONWriter jw, ComponentConfigurationDTO component) {
        String[] services = component.description.serviceInterfaces;
        if (services == null) {
            return;
        }
        this.keyVal(jw, "Service Type", component.description.scope);
        JSONArray buf = new JSONArray();
        for (int i = 0; i < services.length; ++i) {
            buf.put((Object)services[i]);
        }
        this.keyVal(jw, "Services", buf);
    }

    private SatisfiedReferenceDTO findReference(ComponentConfigurationDTO component, String name) {
        for (SatisfiedReferenceDTO dto : component.satisfiedReferences) {
            if (!dto.name.equals(name)) continue;
            return dto;
        }
        return null;
    }

    private void listReferences(JSONWriter jw, ComponentConfigurationDTO component) {
        for (ReferenceDTO dto : component.description.references) {
            JSONArray buf = new JSONArray();
            SatisfiedReferenceDTO satisfiedRef = this.findReference(component, dto.name);
            buf.put((Object)(satisfiedRef != null ? "Satisfied" : "Unsatisfied"));
            buf.put((Object)("Service Name: " + dto.interfaceName));
            if (dto.target != null) {
                buf.put((Object)("Target Filter: " + dto.target));
            }
            buf.put((Object)("Cardinality: " + dto.cardinality));
            buf.put((Object)("Policy: " + dto.policy));
            buf.put((Object)("Policy Option: " + dto.policyOption));
            if (satisfiedRef != null) {
                for (int j = 0; j < satisfiedRef.boundServices.length; ++j) {
                    StringBuffer b = new StringBuffer();
                    b.append("Bound Service ID ");
                    b.append(satisfiedRef.boundServices[j].id);
                    String name = (String)satisfiedRef.boundServices[j].properties.get("component.name");
                    if (name == null && (name = (String)satisfiedRef.boundServices[j].properties.get("service.pid")) == null) {
                        name = (String)satisfiedRef.boundServices[j].properties.get("service.description");
                    }
                    if (name != null) {
                        b.append(" (");
                        b.append(name);
                        b.append(")");
                    }
                    buf.put((Object)b.toString());
                }
            } else {
                buf.put((Object)"No Services bound");
            }
            this.keyVal(jw, "Reference " + dto.name, buf.toString());
        }
    }

    private void listProperties(JSONWriter jw, ComponentConfigurationDTO component) {
        Map props = component.properties;
        if (props != null) {
            JSONArray buf = new JSONArray();
            TreeSet keys = new TreeSet(props.keySet());
            for (String key : keys) {
                StringBuilder b = new StringBuilder();
                b.append(key).append(" = ");
                Object prop = props.get(key);
                prop = WebConsoleUtil.toString(prop);
                b.append(prop);
                buf.put((Object)b.toString());
            }
            this.keyVal(jw, "Properties", buf);
        }
    }

    private void keyVal(JSONWriter jw, String key, Object value) {
        try {
            WebConsoleUtil.keyVal((JSONWriter)jw, (String)key, (Object)value);
        }
        catch (JSONException je) {
            // empty catch block
        }
    }

    private boolean isConfigurable(Bundle providingBundle, String pid) {
        MetaTypeInformation mti;
        MetaTypeService mts;
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (ca != null) {
            try {
                String filter = "(service.pid=" + pid + ')';
                Configuration[] configs = ca.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    return true;
                }
            }
            catch (InvalidSyntaxException ise) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (providingBundle != null && (mts = this.getMetaTypeService()) != null && (mti = mts.getMetaTypeInformation(providingBundle)) != null) {
            try {
                return mti.getObjectClassDefinition(pid, null) != null;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    private final ConfigurationAdmin getConfigurationAdmin() {
        return (ConfigurationAdmin)this.getService(CONFIGURATION_ADMIN_NAME);
    }

    final ServiceComponentRuntime getScrService() {
        return (ServiceComponentRuntime)this.getService(SCR_SERVICE);
    }

    private final MetaTypeService getMetaTypeService() {
        return (MetaTypeService)this.getService(META_TYPE_NAME);
    }

    static RequestInfo getRequestInfo(HttpServletRequest request) {
        return (RequestInfo)request.getAttribute(WebConsolePlugin.class.getName());
    }

    private final class RequestInfo {
        public final String extension;
        public final ComponentConfigurationDTO component;
        public final boolean componentRequested;
        public final ServiceComponentRuntime scrService;
        public final List<ComponentDescriptionDTO> descriptions = new ArrayList<ComponentDescriptionDTO>();
        public final List<ComponentConfigurationDTO> configurations = new ArrayList<ComponentConfigurationDTO>();

        protected RequestInfo(HttpServletRequest request) {
            this.scrService = WebConsolePlugin.this.getScrService();
            if (this.scrService != null) {
                Collection descs = this.scrService.getComponentDescriptionDTOs(new Bundle[0]);
                for (ComponentDescriptionDTO d : descs) {
                    for (ComponentConfigurationDTO cfg : this.scrService.getComponentConfigurationDTOs(d)) {
                        this.configurations.add(cfg);
                    }
                    this.descriptions.add(d);
                }
                Collections.sort(this.configurations, Util.COMPONENT_COMPARATOR);
            }
            String info = request.getPathInfo();
            if ((info = info.substring(WebConsolePlugin.this.getLabel().length() + 1)).endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            if (info.length() > 1 && info.startsWith("/")) {
                this.componentRequested = true;
                ComponentConfigurationDTO component = this.getComponentId(info = info.substring(1));
                if (component == null) {
                    component = this.getComponentByName(info);
                }
                this.component = component;
            } else {
                this.componentRequested = false;
                this.component = null;
            }
            request.setAttribute(((Object)((Object)WebConsolePlugin.this)).getClass().getName(), (Object)this);
        }

        protected ComponentConfigurationDTO getComponentId(String componentIdPar) {
            try {
                long componentId = Long.parseLong(componentIdPar);
                for (ComponentConfigurationDTO cfg : this.configurations) {
                    if (cfg.id != componentId) continue;
                    return cfg;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }

        protected ComponentConfigurationDTO getComponentByName(String names) {
            if (names.length() > 0) {
                String pid;
                String componentName;
                int slash = names.lastIndexOf(47);
                if (slash > 0) {
                    componentName = names.substring(0, slash);
                    pid = names.substring(slash + 1);
                } else {
                    componentName = names;
                    pid = null;
                }
                Collection components = null;
                try {
                    for (ComponentDescriptionDTO d : this.descriptions) {
                        if (!d.name.equals(componentName)) continue;
                        components = this.scrService.getComponentConfigurationDTOs(d);
                    }
                }
                catch (Throwable t) {
                    components = null;
                }
                if (components != null) {
                    if (pid != null) {
                        for (ComponentConfigurationDTO c : components) {
                            if (!pid.equals(c.properties.get("service.pid"))) continue;
                            return c;
                        }
                    } else if (components.size() > 0) {
                        return (ComponentConfigurationDTO)components.iterator().next();
                    }
                }
            }
            return null;
        }
    }
}

