/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.shell.remote.AtomicInteger;
import org.apache.felix.shell.remote.ServiceMediator;
import org.apache.felix.shell.remote.Shell;
import org.osgi.framework.BundleContext;

class Listener {
    private final int m_port;
    private final String m_ip;
    private final Thread m_listenerThread;
    private final Acceptor m_acceptor;
    private final AtomicInteger m_useCounter;
    private final int m_maxConnections;
    private final int m_soTimeout;
    private final Set m_connections;
    private final ServiceMediator m_services;
    private static final String INUSE_MESSAGE = "Connection refused.\r\nAll possible connections are currently being used.\r\n";

    public Listener(BundleContext context, ServiceMediator services) throws IOException {
        this.m_services = services;
        this.m_ip = this.getProperty(context, "osgi.shell.telnet.ip", "127.0.0.1");
        this.m_port = this.getProperty(context, "osgi.shell.telnet.port", 6666);
        this.m_soTimeout = this.getProperty(context, "osgi.shell.telnet.socketTimeout", 0);
        this.m_maxConnections = this.getProperty(context, "osgi.shell.telnet.maxconn", 2);
        this.m_useCounter = new AtomicInteger(0);
        this.m_connections = new HashSet();
        this.m_acceptor = new Acceptor();
        this.m_listenerThread = new Thread((Runnable)this.m_acceptor, "telnetconsole.Listener");
        this.m_listenerThread.start();
    }

    public ServiceMediator getServices() {
        return this.m_services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Shell[] connections;
        try {
            this.m_acceptor.close();
            this.m_listenerThread.join();
        }
        catch (Exception ex) {
            this.m_services.error("Listener::deactivate()", ex);
        }
        Set set = this.m_connections;
        synchronized (set) {
            connections = this.m_connections.toArray(new Shell[this.m_connections.size()]);
            this.m_connections.clear();
        }
        for (int i = 0; i < connections.length; ++i) {
            connections[i].terminate();
        }
    }

    private int getProperty(BundleContext bundleContext, String propName, int defaultValue) {
        String propValue = bundleContext.getProperty(propName);
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (NumberFormatException ex) {
                this.m_services.error("Listener::activate()", ex);
            }
        }
        return defaultValue;
    }

    private String getProperty(BundleContext bundleContext, String propName, String defaultValue) {
        String propValue = bundleContext.getProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConnection(Shell connection) {
        Set set = this.m_connections;
        synchronized (set) {
            this.m_connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterConnection(Shell connection) {
        Set set = this.m_connections;
        synchronized (set) {
            this.m_connections.remove(connection);
        }
    }

    private class Acceptor
    implements Runnable {
        private volatile boolean m_stop = false;
        private final ServerSocket m_serverSocket;

        Acceptor() throws IOException {
            this.m_serverSocket = new ServerSocket(Listener.this.m_port, 1, InetAddress.getByName(Listener.this.m_ip));
            this.m_serverSocket.setSoTimeout(Listener.this.m_soTimeout);
        }

        public void close() throws IOException {
            this.m_stop = true;
            this.m_serverSocket.close();
        }

        public void run() {
            try {
                do {
                    try {
                        Socket s = this.m_serverSocket.accept();
                        if (Listener.this.m_useCounter.get() >= Listener.this.m_maxConnections) {
                            PrintStream out = new PrintStream(s.getOutputStream());
                            out.print(Listener.INUSE_MESSAGE);
                            out.flush();
                            out.close();
                            s.close();
                            continue;
                        }
                        Listener.this.m_useCounter.increment();
                        Thread connectionThread = new Thread(new Shell(Listener.this, s, Listener.this.m_useCounter));
                        connectionThread.setName("telnetconsole.shell remote=" + s.getRemoteSocketAddress());
                        connectionThread.start();
                    }
                    catch (SocketException s) {
                    }
                    catch (SocketTimeoutException s) {
                        // empty catch block
                    }
                } while (!this.m_stop);
            }
            catch (IOException e) {
                Listener.this.m_services.error("Listener.Acceptor::run()", e);
            }
        }
    }
}

