/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.logger;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import org.apache.felix.scr.impl.logger.BundleLogger;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.LogConfiguration;
import org.apache.felix.scr.impl.logger.LogManager;
import org.apache.felix.scr.impl.logger.ScrLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.Logger;

public class ScrLogManager
extends LogManager {
    private final Bundle bundle;
    private final LogConfiguration config;

    ScrLogManager(BundleContext context, LogConfiguration config) {
        super(context, config);
        this.config = config;
        this.bundle = context.getBundle();
    }

    public ScrLogger scr() {
        ScrLoggerFacade scrl = super.getLogger(this.bundle, "ROOT", ScrLoggerFacade.class);
        scrl.setPrefix(this.getBundleIdentifier(this.bundle));
        return scrl;
    }

    public BundleLogger bundle(Bundle bundle) {
        ScrLoggerFacade logger = this.getLogger(bundle, "ROOT", ScrLoggerFacade.class);
        logger.setPrefix(this.getBundleIdentifier(bundle));
        return logger;
    }

    public ComponentLogger component(Bundle bundle, String implementationClass, String name) {
        ScrLoggerFacade facade = this.getLogger(bundle, implementationClass, ScrLoggerFacade.class);
        facade.setComponentId(-1L);
        return facade;
    }

    @Override
    LogManager.LoggerFacade createLoggerFacade(LogManager.LogDomain logDomain, String name) {
        return new ScrLoggerFacade(logDomain, name);
    }

    InternalLogger.Level getLogLevel() {
        return this.config.getLogLevel();
    }

    String getBundleIdentifier(Bundle bundle) {
        StringBuilder sb = new StringBuilder("bundle ");
        if (bundle.getSymbolicName() != null) {
            sb.append(bundle.getSymbolicName());
            sb.append(':');
            sb.append(bundle.getVersion());
            sb.append(" (");
            sb.append(bundle.getBundleId());
            sb.append(")");
        } else {
            sb.append(bundle.getBundleId());
        }
        return sb.toString();
    }

    String componentPrefix(ScrLoggerFacade slf, long id) {
        if (id >= 0L) {
            return String.valueOf(this.getBundleIdentifier(slf.getBundle())) + "[" + slf.getName() + "(" + id + ")] :";
        }
        return String.valueOf(this.getBundleIdentifier(slf.getBundle())) + "[" + slf.getName() + "] :";
    }

    String format(String pattern, Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return pattern;
        }
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] instanceof Bundle) {
                arguments[i] = this.getBundleIdentifier((Bundle)arguments[i]);
            }
            ++i;
        }
        return MessageFormat.format(pattern, arguments);
    }

    class ScrLoggerFacade
    extends LogManager.LoggerFacade
    implements InternalLogger,
    ScrLogger,
    BundleLogger,
    ComponentLogger {
        ScrLoggerFacade(LogManager.LogDomain logDomain, String name) {
            super(logDomain, name);
        }

        @Override
        public void setComponentId(long id) {
            this.setPrefix(ScrLogManager.this.componentPrefix(this, id));
        }

        @Override
        public boolean isLogEnabled(InternalLogger.Level level) {
            Object checkLogger = this.getLogger();
            if (checkLogger != null) {
                Logger logger = (Logger)checkLogger;
                switch (level) {
                    case AUDIT: {
                        return true;
                    }
                    case ERROR: {
                        return logger.isErrorEnabled();
                    }
                    case WARN: {
                        return logger.isWarnEnabled();
                    }
                    case INFO: {
                        return logger.isInfoEnabled();
                    }
                    case TRACE: {
                        return logger.isTraceEnabled();
                    }
                }
                return logger.isDebugEnabled();
            }
            return ScrLogManager.this.getLogLevel().implies(level);
        }

        @Override
        public void log(InternalLogger.Level level, String format, Throwable ex, Object ... arguments) {
            if (this.isLogEnabled(level)) {
                this.log0(level, ScrLogManager.this.format(format, arguments), ex);
            }
        }

        @Override
        public void log(InternalLogger.Level level, String message, Throwable ex) {
            if (this.isLogEnabled(level)) {
                this.log0(level, message, ex);
            }
        }

        void log0(InternalLogger.Level level, String message, Throwable ex) {
            Object checkLogger;
            if (this.prefix != null && this.prefix.length() > 0) {
                message = this.prefix.concat(" ").concat(message);
            }
            if ((checkLogger = this.getLogger()) != null) {
                Logger logger = (Logger)checkLogger;
                if (ex == null) {
                    switch (level) {
                        case AUDIT: {
                            logger.audit(message);
                            break;
                        }
                        case ERROR: {
                            logger.error(message);
                            break;
                        }
                        case WARN: {
                            logger.warn(message);
                            break;
                        }
                        case INFO: {
                            logger.info(message);
                            break;
                        }
                        case TRACE: {
                            logger.trace(message);
                            break;
                        }
                        default: {
                            logger.debug(message);
                            break;
                        }
                    }
                } else {
                    switch (level) {
                        case AUDIT: {
                            logger.audit(message, (Object)ex);
                            break;
                        }
                        case ERROR: {
                            logger.error(message, (Object)ex);
                            break;
                        }
                        case WARN: {
                            logger.warn(message, (Object)ex);
                            break;
                        }
                        case INFO: {
                            logger.info(message, (Object)ex);
                            break;
                        }
                        case TRACE: {
                            logger.trace(message, (Object)ex);
                            break;
                        }
                        default: {
                            logger.debug(message, (Object)ex);
                            break;
                        }
                    }
                }
            } else {
                StringWriter buf = new StringWriter();
                String l = String.format("%-5s", new Object[]{level});
                buf.append(l).append(" : ").append(message);
                if (ex != null) {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (PrintWriter pw = new PrintWriter(buf);){
                        pw.println();
                        ex.printStackTrace(pw);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                PrintStream out = level.err() ? System.err : System.out;
                out.println(buf);
            }
        }

        void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public ComponentLogger component(Bundle bundle, String implementationClassName, String name) {
            return ScrLogManager.this.component(bundle, implementationClassName, name);
        }

        @Override
        public BundleLogger bundle(Bundle bundle) {
            return ScrLogManager.this.bundle(bundle);
        }

        @Override
        public void close() {
            ScrLogManager.this.close();
        }
    }
}

