/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.scr.impl.inject.BindParameters;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.inject.ReferenceMethod;
import org.apache.felix.scr.impl.inject.ScrComponentContext;
import org.apache.felix.scr.impl.inject.ValueUtils;
import org.apache.felix.scr.impl.inject.internal.ClassUtils;
import org.apache.felix.scr.impl.inject.methods.BaseMethod;
import org.apache.felix.scr.impl.inject.methods.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.osgi.framework.BundleContext;

public class BindMethod
extends BaseMethod<BindParameters, List<ValueUtils.ValueType>>
implements ReferenceMethod {
    private final String m_referenceClassName;
    private volatile List<ValueUtils.ValueType> m_paramTypes = Collections.emptyList();

    public BindMethod(String methodName, Class<?> componentClass, String referenceClassName, DSVersion dsVersion, boolean configurableServiceProperties) {
        super(methodName, methodName != null, componentClass, dsVersion, configurableServiceProperties);
        this.m_referenceClassName = referenceClassName;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected BaseMethod.MethodInfo<List<ValueUtils.ValueType>> doFindMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        block51: {
            block50: {
                suitableMethodNotAccessible = false;
                if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                    logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Looking for method " + targetClass.getName() + "." + this.getMethodName(), null);
                }
                try {
                    method = this.getServiceReferenceMethod(targetClass, acceptPrivate, acceptPackage, logger);
                    if (method != null) {
                        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                            logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                        }
                        return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_serviceReference));
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
                if (this.getDSVersion().isDS13()) {
                    try {
                        method = this.getComponentObjectsMethod(targetClass, acceptPrivate, acceptPackage, logger);
                        if (method != null) {
                            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                                logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                            }
                            return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_serviceObjects));
                        }
                    }
                    catch (SuitableMethodNotAccessibleException ex) {
                        suitableMethodNotAccessible = true;
                    }
                }
                if ((parameterClass = ClassUtils.getClassFromComponentClassLoader(targetClass, this.m_referenceClassName, logger)) == null) break block50;
                if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                    logger.log(InternalLogger.Level.DEBUG, "doFindMethod: No method taking ServiceReference found, checking method taking " + parameterClass.getName(), null);
                }
                try {
                    method = this.getServiceObjectMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                    if (method != null) {
                        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                            logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                        }
                        return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_serviceType));
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
                try {
                    method = this.getServiceObjectAssignableMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                    if (method != null) {
                        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                            logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                        }
                        return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_serviceType));
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
                if (this.getDSVersion().isDS13()) {
                    try {
                        method = this.getMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                        if (method != null) {
                            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                                logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                            }
                            return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_map));
                        }
                    }
                    catch (SuitableMethodNotAccessibleException ex) {
                        suitableMethodNotAccessible = true;
                    }
                }
                if (this.getDSVersion().isDS11() && !this.getDSVersion().isDS13()) {
                    try {
                        method = this.getServiceObjectWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                        if (method != null) {
                            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                                logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                            }
                            paramTypes = new ArrayList<ValueUtils.ValueType>(2);
                            paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                            paramTypes.add(ValueUtils.ValueType.ref_map);
                            return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, paramTypes);
                        }
                    }
                    catch (SuitableMethodNotAccessibleException ex) {
                        suitableMethodNotAccessible = true;
                    }
                    try {
                        method = this.getServiceObjectAssignableWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                        if (method != null) {
                            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                                logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                            }
                            paramTypes = new ArrayList<E>(2);
                            paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                            paramTypes.add(ValueUtils.ValueType.ref_map);
                            return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, paramTypes);
                        }
                    }
                    catch (SuitableMethodNotAccessibleException ex) {
                        suitableMethodNotAccessible = true;
                    }
                }
                if (!this.getDSVersion().isDS13()) break block51;
                var11_16 = targetClass.getDeclaredMethods();
                var10_17 = var11_16.length;
                var9_18 = 0;
                while (var9_18 < var10_17) {
                    block52: {
                        m = var11_16[var9_18];
                        if (!this.getMethodName().equals(m.getName())) break block52;
                        parameterTypes = m.getParameterTypes();
                        matches = true;
                        specialMatch = true;
                        paramTypes = new ArrayList<ValueUtils.ValueType>(parameterTypes.length);
                        var19_26 = parameterTypes;
                        var18_25 = parameterTypes.length;
                        var17_24 = 0;
                        while (var17_24 < var18_25) {
                            block54: {
                                block57: {
                                    block56: {
                                        block55: {
                                            block53: {
                                                paramType = var19_26[var17_24];
                                                if (paramType != ClassUtils.SERVICE_REFERENCE_CLASS) break block53;
                                                if (specialMatch && parameterClass == ClassUtils.SERVICE_REFERENCE_CLASS) {
                                                    specialMatch = false;
                                                    paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                                                } else {
                                                    paramTypes.add(ValueUtils.ValueType.ref_serviceReference);
                                                }
                                                break block54;
                                            }
                                            if (paramType != ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS) break block55;
                                            if (specialMatch && parameterClass == ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS) {
                                                specialMatch = false;
                                                paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                                            } else {
                                                paramTypes.add(ValueUtils.ValueType.ref_serviceObjects);
                                            }
                                            break block54;
                                        }
                                        if (paramType != ClassUtils.MAP_CLASS) break block56;
                                        if (specialMatch && parameterClass == ClassUtils.MAP_CLASS) {
                                            specialMatch = false;
                                            paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                                        } else {
                                            paramTypes.add(ValueUtils.ValueType.ref_map);
                                        }
                                        break block54;
                                    }
                                    if (!paramType.isAssignableFrom(parameterClass)) break block57;
                                    paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                                    break block54;
                                }
                                if (!this.getDSVersion().isDS14() || !"org.osgi.service.log.LoggerFactory".equals(this.m_referenceClassName)) ** GOTO lbl145
                                if (paramType.getName().equals("org.osgi.service.log.Logger")) {
                                    paramTypes.add(ValueUtils.ValueType.ref_logger);
                                } else if (paramType.getName().equals("org.osgi.service.log.FormatterLogger")) {
                                    paramTypes.add(ValueUtils.ValueType.ref_formatterLogger);
                                } else {
                                    matches = false;
                                    break;
lbl145:
                                    // 1 sources

                                    matches = false;
                                    break;
                                }
                            }
                            ++var17_24;
                        }
                        if (matches) {
                            if (BindMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                                if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                                    logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + m, null);
                                }
                                return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(m, paramTypes);
                            }
                            suitableMethodNotAccessible = true;
                        }
                    }
                    ++var9_18;
                }
                break block51;
            }
            if (logger.isLogEnabled(InternalLogger.Level.WARN)) {
                logger.log(InternalLogger.Level.WARN, "doFindMethod: Cannot check for methods taking parameter class " + this.m_referenceClassName + ": " + targetClass.getName() + " does not see it", null);
            }
        }
        if (suitableMethodNotAccessible) {
            logger.log(InternalLogger.Level.ERROR, "doFindMethod: Suitable but non-accessible method found in class {0}", null, new Object[]{targetClass.getName()});
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    @Override
    protected void setTypes(List<ValueUtils.ValueType> types) {
        this.m_paramTypes = types;
    }

    private Method getServiceReferenceMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.SERVICE_REFERENCE_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getComponentObjectsMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectAssignableMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
            logger.log(InternalLogger.Level.DEBUG, "getServiceObjectAssignableMethod: Checking " + candidateBindMethods.length + " declared method in class " + targetClass.getName(), null);
        }
        int i = 0;
        while (i < candidateBindMethods.length) {
            Class<?>[] parameters;
            Method method = candidateBindMethods[i];
            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                logger.log(InternalLogger.Level.DEBUG, "getServiceObjectAssignableMethod: Checking " + method, null);
            }
            if ((parameters = method.getParameterTypes()).length == 1 && method.getName().equals(this.getMethodName())) {
                Class<?> theParameter;
                if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                    logger.log(InternalLogger.Level.DEBUG, "getServiceObjectAssignableMethod: Considering " + method, null);
                }
                if ((theParameter = parameters[0]).isAssignableFrom(parameterClass)) {
                    if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                        return method;
                    }
                    suitableNotAccessible = true;
                } else if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                    logger.log(InternalLogger.Level.DEBUG, "getServiceObjectAssignableMethod: Parameter failure: Required " + theParameter + "; actual " + parameterClass.getName(), null);
                }
            }
            ++i;
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getServiceObjectWithMapMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass, ClassUtils.MAP_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectAssignableWithMapMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        int i = 0;
        while (i < candidateBindMethods.length) {
            Method method = candidateBindMethods[i];
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length == 2 && method.getName().equals(this.getMethodName()) && parameters[0].isAssignableFrom(parameterClass) && parameters[1] == ClassUtils.MAP_CLASS) {
                if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                    return method;
                }
                suitableNotAccessible = true;
            }
            ++i;
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getMapMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.MAP_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    @Override
    public <S, T> boolean getServiceObject(BindParameters parameters, BundleContext context) {
        if (parameters.getRefPair().getServiceObject(parameters.getComponentContext()) == null && this.methodExists(parameters.getComponentContext().getLogger()) && (this.m_paramTypes.contains((Object)ValueUtils.ValueType.ref_serviceType) || this.m_paramTypes.contains((Object)ValueUtils.ValueType.ref_logger) || this.m_paramTypes.contains((Object)ValueUtils.ValueType.ref_formatterLogger))) {
            return parameters.getRefPair().getServiceObject(parameters.getComponentContext(), context);
        }
        return true;
    }

    @Override
    protected Object[] getParameters(Method method, BindParameters bp) {
        ScrComponentContext key = bp.getComponentContext();
        Object[] result = new Object[this.m_paramTypes.size()];
        RefPair<?, ?> refPair = bp.getRefPair();
        int i = 0;
        for (ValueUtils.ValueType pt : this.m_paramTypes) {
            result[i] = ValueUtils.getValue(this.getComponentClass().getName(), pt, method.getParameterTypes()[i], key, refPair, null);
            ++i;
        }
        return result;
    }

    @Override
    protected String getMethodNamePrefix() {
        return "bind";
    }
}

