/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.internal;

import java.util.List;
import org.apache.felix.scr.impl.inject.BindParameters;
import org.apache.felix.scr.impl.inject.InitReferenceMethod;
import org.apache.felix.scr.impl.inject.MethodResult;
import org.apache.felix.scr.impl.inject.ReferenceMethod;
import org.apache.felix.scr.impl.inject.ReferenceMethods;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.osgi.framework.BundleContext;

public class DuplexReferenceMethods
implements ReferenceMethods {
    private final ReferenceMethod bind;
    private final ReferenceMethod updated;
    private final ReferenceMethod unbind;
    private final InitReferenceMethod init;

    public DuplexReferenceMethods(final List<ReferenceMethods> methods) {
        ReferenceMethod[] bindList = new ReferenceMethod[methods.size()];
        ReferenceMethod[] updatedList = new ReferenceMethod[methods.size()];
        ReferenceMethod[] unbindList = new ReferenceMethod[methods.size()];
        int index = 0;
        for (ReferenceMethods m : methods) {
            bindList[index] = m.getBind();
            updatedList[index] = m.getUpdated();
            unbindList[index] = m.getUnbind();
            ++index;
        }
        this.bind = new DuplexReferenceMethod(bindList);
        this.updated = new DuplexReferenceMethod(updatedList);
        this.unbind = new DuplexReferenceMethod(unbindList);
        this.init = new InitReferenceMethod(){

            @Override
            public boolean init(Object componentInstance, ComponentLogger logger) {
                boolean result = true;
                for (ReferenceMethods m : methods) {
                    InitReferenceMethod init = m.getInit();
                    if (init != null && !(result = init.init(componentInstance, logger))) break;
                }
                return result;
            }
        };
    }

    @Override
    public ReferenceMethod getBind() {
        return this.bind;
    }

    @Override
    public ReferenceMethod getUnbind() {
        return this.unbind;
    }

    @Override
    public ReferenceMethod getUpdated() {
        return this.updated;
    }

    @Override
    public InitReferenceMethod getInit() {
        return this.init;
    }

    private static final class DuplexReferenceMethod
    implements ReferenceMethod {
        private final ReferenceMethod[] methods;

        public DuplexReferenceMethod(ReferenceMethod[] methods) {
            this.methods = methods;
        }

        @Override
        public MethodResult invoke(Object componentInstance, BindParameters parameters, MethodResult methodCallFailureResult) {
            MethodResult result = null;
            ReferenceMethod[] referenceMethodArray = this.methods;
            int n = this.methods.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceMethod m = referenceMethodArray[n2];
                result = m.invoke(componentInstance, parameters, methodCallFailureResult);
                if (result == null) break;
                ++n2;
            }
            return result;
        }

        @Override
        public <S, T> boolean getServiceObject(BindParameters parameters, BundleContext context) {
            boolean result = false;
            ReferenceMethod[] referenceMethodArray = this.methods;
            int n = this.methods.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceMethod m = referenceMethodArray[n2];
                result = m.getServiceObject(parameters, context);
                if (!result) break;
                ++n2;
            }
            return result;
        }
    }
}

