/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.impl.inject.ComponentConstructor;
import org.apache.felix.scr.impl.inject.OpenStatus;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.inject.ScrComponentContext;
import org.apache.felix.scr.impl.inject.ValueUtils;
import org.apache.felix.scr.impl.inject.field.FieldUtils;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;

public class ComponentConstructorImpl<S>
implements ComponentConstructor<S> {
    private final Field[] activationFields;
    private final ValueUtils.ValueType[] activationFieldTypes;
    private final Constructor<S> constructor;
    private final ValueUtils.ValueType[] constructorArgTypes;
    private final ReferenceMetadata[] constructorRefs;

    public ComponentConstructorImpl(ComponentMetadata componentMetadata, Class<S> componentClass, ComponentLogger logger) {
        Constructor<?>[] constructors;
        HashMap<Integer, ArrayList<ReferenceMetadata>> paramMap = componentMetadata.getNumberOfConstructorParameters() > 0 ? new HashMap<Integer, ArrayList<ReferenceMetadata>>() : null;
        for (ReferenceMetadata refMetadata : componentMetadata.getDependencies()) {
            if (refMetadata.getParameterIndex() == null) continue;
            int index = refMetadata.getParameterIndex();
            if (index > componentMetadata.getNumberOfConstructorParameters()) {
                logger.log(InternalLogger.Level.ERROR, "Ignoring reference {0} for constructor injection. Parameter index is too high.", null, refMetadata.getName());
            } else if (!refMetadata.isStatic()) {
                logger.log(InternalLogger.Level.ERROR, "Ignoring reference {0} for constructor injection. Reference is dynamic.", null, refMetadata.getName());
            }
            ArrayList<ReferenceMetadata> list = (ArrayList<ReferenceMetadata>)paramMap.get(index);
            if (list == null) {
                list = new ArrayList<ReferenceMetadata>();
                paramMap.put(index, list);
            }
            list.add(refMetadata);
        }
        Constructor<?> found = null;
        ValueUtils.ValueType[] foundTypes = null;
        ReferenceMetadata[] foundRefs = null;
        Constructor<?>[] constructorArray = constructors = componentClass.getConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            if (c.getParameterTypes().length == componentMetadata.getNumberOfConstructorParameters()) {
                Constructor<?> check = c;
                logger.log(InternalLogger.Level.DEBUG, "Checking constructor {0}", null, check);
                if (componentMetadata.getNumberOfConstructorParameters() > 0) {
                    boolean hasFailure = false;
                    Class<?>[] argTypes = check.getParameterTypes();
                    foundTypes = new ValueUtils.ValueType[argTypes.length];
                    foundRefs = new ReferenceMetadata[argTypes.length];
                    int i = 0;
                    while (i < foundTypes.length) {
                        List refs = (List)paramMap.get(i);
                        if (refs == null) {
                            foundTypes[i] = ValueUtils.getValueType(argTypes[i]);
                            if (foundTypes[i] == ValueUtils.ValueType.ignore) {
                                logger.log(InternalLogger.Level.DEBUG, "Constructor argument type {0} not supported by constructor injection: {1}", null, i, argTypes[i]);
                            }
                        } else {
                            for (ReferenceMetadata ref : refs) {
                                ValueUtils.ValueType t = ValueUtils.getReferenceValueType(componentClass, ref, argTypes[i], null, logger);
                                if (t == null) continue;
                                foundTypes[i] = t;
                                foundRefs[i] = ref;
                                break;
                            }
                            if (foundTypes[i] == null) {
                                foundTypes[i] = ValueUtils.ValueType.ignore;
                            } else if (refs.size() > 1) {
                                logger.log(InternalLogger.Level.ERROR, "Several references for constructor injection of parameter {0}. Only {1} will be used out of: {2}.", null, i, foundRefs[i].getName(), this.getNames(refs));
                            }
                        }
                        if (foundTypes[i] == ValueUtils.ValueType.ignore) {
                            hasFailure = true;
                            break;
                        }
                        ++i;
                    }
                    if (!hasFailure) {
                        found = check;
                        break;
                    }
                } else {
                    found = c;
                    break;
                }
            }
            ++n2;
        }
        this.constructor = found;
        this.constructorArgTypes = foundTypes;
        this.constructorRefs = foundRefs;
        if (componentMetadata.getActivationFields() != null) {
            this.activationFieldTypes = new ValueUtils.ValueType[componentMetadata.getActivationFields().size()];
            this.activationFields = new Field[this.activationFieldTypes.length];
            int index = 0;
            for (String fieldName : componentMetadata.getActivationFields()) {
                FieldUtils.FieldSearchResult result = FieldUtils.searchField(componentClass, fieldName, logger);
                if (result == null || result.field == null) {
                    this.activationFieldTypes[index] = null;
                    this.activationFields[index] = null;
                } else if (result.usable) {
                    this.activationFieldTypes[index] = ValueUtils.getValueType(result.field.getType());
                    this.activationFields[index] = result.field;
                } else {
                    this.activationFieldTypes[index] = ValueUtils.ValueType.ignore;
                    this.activationFields[index] = null;
                }
                ++index;
            }
        } else {
            this.activationFieldTypes = ValueUtils.EMPTY_VALUE_TYPES;
            this.activationFields = null;
        }
        if (this.constructor == null) {
            logger.log(InternalLogger.Level.ERROR, "Constructor with {0} arguments not found. Component will fail.", null, componentMetadata.getNumberOfConstructorParameters());
        } else {
            logger.log(InternalLogger.Level.DEBUG, "Found constructor with {0} arguments : {1}", null, componentMetadata.getNumberOfConstructorParameters(), found);
        }
    }

    @Override
    public <T> S newInstance(ScrComponentContext componentContext, Map<ReferenceMetadata, OpenStatus<S, ?>> parameterMap) throws Exception {
        Object[] args;
        if (this.constructor == null) {
            throw new InstantiationException("Constructor not found.");
        }
        if (this.constructorArgTypes == null) {
            args = null;
        } else {
            args = new Object[this.constructorArgTypes.length];
            int i = 0;
            while (i < args.length) {
                OpenStatus<S, ?> status;
                ReferenceMetadata refMetadata = this.constructorRefs[i];
                OpenStatus<S, ?> openStatus = status = refMetadata == null ? null : parameterMap.get(refMetadata);
                if (refMetadata == null) {
                    args[i] = ValueUtils.getValue(this.constructor.getDeclaringClass().getName(), this.constructorArgTypes[i], this.constructor.getParameterTypes()[i], componentContext, null, refMetadata);
                } else {
                    ArrayList<Object> refs = refMetadata.isMultiple() ? new ArrayList<Object>() : null;
                    Object ref = null;
                    for (RefPair<S, ?> refPair : status.getRefs(new AtomicInteger())) {
                        if (refPair.isDeleted() || refPair.isFailed()) continue;
                        if (refPair.getServiceObject(componentContext) == null && (this.constructorArgTypes[i] == ValueUtils.ValueType.ref_serviceType || this.constructorArgTypes[i] == ValueUtils.ValueType.ref_tuple || this.constructorArgTypes[i] == ValueUtils.ValueType.ref_logger || this.constructorArgTypes[i] == ValueUtils.ValueType.ref_formatterLogger || this.constructorArgTypes[i] == ValueUtils.ValueType.ref_optional)) {
                            refPair.getServiceObject(componentContext, componentContext.getBundleContext());
                        }
                        ref = ValueUtils.getValue(this.constructor.getDeclaringClass().getName(), this.constructorArgTypes[i], this.constructor.getParameterTypes()[i], componentContext, refPair, refMetadata);
                        if (!refMetadata.isMultiple() || ref == null) continue;
                        refs.add(ref);
                    }
                    if (ref == null && this.constructorArgTypes[i] == ValueUtils.ValueType.ref_optional) {
                        ref = Optional.empty();
                    }
                    if (!refMetadata.isMultiple()) {
                        if (ref == null && !refMetadata.isOptional()) {
                            throw new InstantiationException("Unable to get service for reference " + refMetadata.getName());
                        }
                        args[i] = ref;
                    } else {
                        if (refs.isEmpty() && !refMetadata.isOptional()) {
                            throw new InstantiationException("Unable to get service for reference " + refMetadata.getName());
                        }
                        args[i] = refs;
                    }
                }
                ++i;
            }
        }
        S component = this.constructor.newInstance(args);
        int i = 0;
        while (i < this.activationFieldTypes.length) {
            if (this.activationFieldTypes[i] != null && this.activationFieldTypes[i] != ValueUtils.ValueType.ignore) {
                Object value = ValueUtils.getValue(this.constructor.getDeclaringClass().getName(), this.activationFieldTypes[i], this.activationFields[i].getType(), componentContext, null, null);
                FieldUtils.setField(this.activationFields[i], component, value, componentContext.getLogger());
            }
            ++i;
        }
        return component;
    }

    private String getNames(List<ReferenceMetadata> refs) {
        StringBuilder sb = new StringBuilder();
        for (ReferenceMetadata refMetadata : refs) {
            if (sb.length() == 0) {
                sb.append(refMetadata.getName());
                continue;
            }
            sb.append(", ").append(refMetadata.getName());
        }
        return sb.toString();
    }
}

