/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.field;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.felix.scr.impl.inject.internal.ClassUtils;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;

public class FieldUtils {
    public static FieldSearchResult searchField(Class<?> componentClass, String fieldName, ComponentLogger logger) {
        ClassLoader targetClasslLoader = componentClass.getClassLoader();
        String targetPackage = ClassUtils.getPackageName(componentClass);
        Class<?> theClass = componentClass;
        boolean acceptPrivate = true;
        boolean acceptPackage = true;
        while (true) {
            logger.log(InternalLogger.Level.DEBUG, "Locating field {0} in class {1}", null, fieldName, theClass.getName());
            try {
                FieldSearchResult result = FieldUtils.getField(componentClass, theClass, fieldName, acceptPrivate, acceptPackage, logger);
                if (result != null) {
                    return result;
                }
            }
            catch (InvocationTargetException ex) {
                logger.log(InternalLogger.Level.ERROR, "Field {0} cannot be found in component class {1}. The field will be ignored.", ex.getTargetException(), fieldName, componentClass.getName());
                return null;
            }
            theClass = theClass.getSuperclass();
            if (theClass == null) break;
            acceptPackage &= targetClasslLoader == theClass.getClassLoader() && targetPackage.equals(ClassUtils.getPackageName(theClass));
            acceptPrivate = false;
        }
        logger.log(InternalLogger.Level.ERROR, "Field {0} cannot be found in component class {1}. The field will be ignored.", null, fieldName, componentClass.getName());
        return new FieldSearchResult(null, false);
    }

    private static FieldSearchResult getField(Class<?> componentClass, Class<?> targetClass, String fieldName, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws InvocationTargetException {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            return FieldUtils.accept(componentClass, field, acceptPrivate, acceptPackage, logger);
        }
        catch (NoSuchFieldException nsfe) {
            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                logger.log(InternalLogger.Level.DEBUG, "Declared Field {0}.{1} not found", null, targetClass.getName(), fieldName);
            }
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable, "Unexpected problem trying to get field " + fieldName);
        }
        return null;
    }

    private static FieldSearchResult accept(Class<?> componentClass, Field field, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) {
        int mod = field.getModifiers();
        if (Modifier.isStatic(mod)) {
            logger.log(InternalLogger.Level.ERROR, "Field {0} must not be static", null, FieldUtils.toString(componentClass, field));
            return new FieldSearchResult(field, false);
        }
        if (Modifier.isPublic(mod) || Modifier.isProtected(mod)) {
            FieldUtils.setAccessible(field);
            return new FieldSearchResult(field, true);
        }
        if (Modifier.isPrivate(mod)) {
            if (acceptPrivate) {
                FieldUtils.setAccessible(field);
                return new FieldSearchResult(field, true);
            }
        } else if (acceptPackage) {
            FieldUtils.setAccessible(field);
            return new FieldSearchResult(field, true);
        }
        logger.log(InternalLogger.Level.ERROR, "findField: Suitable but non-accessible field {0}", null, FieldUtils.toString(componentClass, field));
        return new FieldSearchResult(field, false);
    }

    public static String toString(Class<?> componentClass, Field field) {
        if (componentClass.getName().equals(field.getDeclaringClass().getName())) {
            return String.valueOf(field.getName()) + " in component class " + componentClass.getName();
        }
        return String.valueOf(field.getName()) + " in class " + field.getDeclaringClass().getName() + ", subclass of component class " + componentClass.getName();
    }

    private static void setAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }

    public static void setField(Field f, Object component, Object value, ComponentLogger logger) {
        try {
            f.set(component, value);
        }
        catch (IllegalArgumentException iae) {
            logger.log(InternalLogger.Level.ERROR, "Field {0} can't be set", iae, f.getName());
        }
        catch (IllegalAccessException iae) {
            logger.log(InternalLogger.Level.ERROR, "Field {0} can't be set", iae, f.getName());
        }
    }

    public static final class FieldSearchResult {
        public final Field field;
        public final boolean usable;

        public FieldSearchResult(Field f, boolean usable) {
            this.field = f;
            this.usable = usable;
        }
    }
}

