/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentServiceObjects;

public class ComponentServiceObjectsHelper {
    private final BundleContext bundleContext;
    private final ConcurrentMap<ServiceReference<?>, ComponentServiceObjectsImpl<?>> services = new ConcurrentHashMap();
    private final List<ComponentServiceObjectsImpl<?>> closedServices = new ArrayList();
    private final ConcurrentMap<ServiceReference<?>, Object> prototypeInstances = new ConcurrentHashMap();

    public ComponentServiceObjectsHelper(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object cso2;
        Collection csos = this.services.values();
        this.services.clear();
        for (Object cso2 : csos) {
            ((ComponentServiceObjectsImpl)cso2).deactivate();
        }
        cso2 = this.closedServices;
        synchronized (cso2) {
            csos = new ArrayList(this.closedServices);
            this.closedServices.clear();
        }
        for (Object cso2 : csos) {
            ((ComponentServiceObjectsImpl)cso2).deactivate();
        }
        this.prototypeInstances.clear();
    }

    public <T> ComponentServiceObjects<T> getServiceObjects(ServiceReference<T> ref) {
        ComponentServiceObjectsImpl oldCSO;
        ServiceObjects serviceObjects;
        ComponentServiceObjectsImpl cso = (ComponentServiceObjectsImpl)this.services.get(ref);
        if (cso == null && (serviceObjects = this.bundleContext.getServiceObjects(ref)) != null && (oldCSO = this.services.putIfAbsent(ref, cso = new ComponentServiceObjectsImpl(serviceObjects))) != null) {
            cso = oldCSO;
        }
        return cso;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeServiceObjects(ServiceReference<?> ref) {
        ComponentServiceObjectsImpl cso = (ComponentServiceObjectsImpl)this.services.remove(ref);
        if (cso != null) {
            List<ComponentServiceObjectsImpl<?>> list = this.closedServices;
            synchronized (list) {
                this.closedServices.add(cso);
            }
            cso.close();
        }
    }

    public <T> T getPrototypeRefInstance(ServiceReference<T> ref) {
        Object oldService;
        Object service = this.prototypeInstances.get(ref);
        if (service == null && (oldService = this.prototypeInstances.putIfAbsent(ref, service = this.getServiceObjects(ref).getService())) != null) {
            this.getServiceObjects(ref).ungetService(service);
            service = oldService;
        }
        return (T)service;
    }

    private static final class ComponentServiceObjectsImpl<T>
    implements ComponentServiceObjects<T> {
        private final List<T> instances = new ArrayList<T>();
        private volatile ServiceObjects<T> serviceObjects;
        private volatile boolean deactivated = false;

        public ComponentServiceObjectsImpl(ServiceObjects<T> so) {
            this.serviceObjects = so;
        }

        public void deactivate() {
            this.deactivated = true;
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            ServiceObjects<T> so = this.serviceObjects;
            this.serviceObjects = null;
            if (so != null) {
                ArrayList<T> localInstances = new ArrayList<T>();
                List<T> list = this.instances;
                synchronized (list) {
                    localInstances.addAll(this.instances);
                    this.instances.clear();
                }
                for (Object obj : localInstances) {
                    try {
                        so.ungetService(obj);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getService() {
            if (this.deactivated) {
                throw new IllegalStateException();
            }
            ServiceObjects<T> so = this.serviceObjects;
            Object service = null;
            if (so != null && (service = so.getService()) != null) {
                List<T> list = this.instances;
                synchronized (list) {
                    this.instances.add(service);
                }
            }
            return (T)service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ungetService(T service) {
            if (this.deactivated) {
                throw new IllegalStateException();
            }
            ServiceObjects<T> so = this.serviceObjects;
            if (so != null) {
                boolean remove;
                List<T> list = this.instances;
                synchronized (list) {
                    remove = this.instances.remove(service);
                }
                if (remove) {
                    so.ungetService(service);
                }
            }
        }

        public ServiceReference<T> getServiceReference() {
            ServiceObjects<T> so = this.serviceObjects;
            if (so != null) {
                return so.getServiceReference();
            }
            return null;
        }

        public String toString() {
            return "ComponentServiceObjectsImpl [instances=" + this.instances + ", serviceObjects=" + this.serviceObjects + ", deactivated=" + this.deactivated + ", hashCode=" + this.hashCode() + "]";
        }
    }
}

