/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.scr.impl.ComponentCommandsScrInfo;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.apache.felix.scr.info.ScrInfo;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ComponentCommands
implements ServiceTrackerCustomizer<Object, ServiceRegistration<?>> {
    private static final String INDENT_1 = "  ";
    private static final String INDENT_2 = "    ";
    private final BundleContext context;
    private final ServiceComponentRuntime scr;
    private final ScrConfiguration scrConfig;
    private final ServiceTracker<Object, ServiceRegistration<?>> gogoRuntimeTracker;
    private final Comparator<ComponentConfigurationDTO> configDtoComparator = new Comparator<ComponentConfigurationDTO>(){

        @Override
        public int compare(ComponentConfigurationDTO o1, ComponentConfigurationDTO o2) {
            long diff = o1.id - o2.id;
            return diff == 0L ? 0 : (int)(diff / Math.abs(diff));
        }
    };
    private final Comparator<ServiceReferenceDTO> serviceRefDtoComparator = new Comparator<ServiceReferenceDTO>(){

        @Override
        public int compare(ServiceReferenceDTO o1, ServiceReferenceDTO o2) {
            long diff = o1.id - o2.id;
            return diff == 0L ? 0 : (int)(diff / Math.abs(diff));
        }
    };
    private ServiceRegistration<ComponentCommands> commandsReg = null;
    private ServiceRegistration<ScrInfo> scrInfoReg = null;

    synchronized void register() {
        if (this.commandsReg != null) {
            throw new IllegalStateException("Component Commands already registered");
        }
        Hashtable<String, Object> svcProps = new Hashtable<String, Object>();
        ((Dictionary)svcProps).put("osgi.command.scope", "scr");
        ((Dictionary)svcProps).put("osgi.command.function", new String[]{"config", "disable", "enable", "info", "list"});
        ((Dictionary)svcProps).put("service.description", "SCR Gogo Shell Support");
        ((Dictionary)svcProps).put("service.vendor", "The Apache Software Foundation");
        this.commandsReg = this.context.registerService(ComponentCommands.class, (Object)this, svcProps);
        this.gogoRuntimeTracker.open(true);
    }

    synchronized void unregister() {
        this.gogoRuntimeTracker.close();
        this.safeUnregister(this.commandsReg);
        this.safeUnregister(this.scrInfoReg);
    }

    public synchronized void updateProvideScrInfoService(boolean register) {
        if (register) {
            if (this.scrInfoReg == null) {
                Hashtable<String, String> svcProps = new Hashtable<String, String>();
                ((Dictionary)svcProps).put("service.description", "SCR Info Service");
                ((Dictionary)svcProps).put("service.vendor", "The Apache Software Foundation");
                this.scrInfoReg = this.context.registerService(ScrInfo.class, (Object)new ComponentCommandsScrInfo(this, this.context), svcProps);
            }
        } else {
            this.safeUnregister(this.scrInfoReg);
            this.scrInfoReg = null;
        }
    }

    protected ComponentCommands(BundleContext context, ServiceComponentRuntime scr, ScrConfiguration scrConfig) {
        this.context = context;
        this.scr = scr;
        this.scrConfig = scrConfig;
        this.gogoRuntimeTracker = new ServiceTracker(context, "org.apache.felix.service.command.CommandProcessor", (ServiceTrackerCustomizer)this);
    }

    @Descriptor(value="List all components")
    public ComponentDescriptionDTO[] list() {
        ComponentDescriptionDTO[] result = this.scr.getComponentDescriptionDTOs(new Bundle[0]).toArray(new ComponentDescriptionDTO[0]);
        Arrays.sort(result, new Comparator<ComponentDescriptionDTO>(){

            @Override
            public int compare(ComponentDescriptionDTO c1, ComponentDescriptionDTO c2) {
                return Long.compare(c1.bundle.id, c2.bundle.id);
            }
        });
        return result;
    }

    @Descriptor(value="List components of a specific bundle")
    public ComponentDescriptionDTO[] list(@Descriptor(value="ID of the bundle") long bundleId) {
        Bundle bundle = this.context.getBundle(bundleId);
        return bundle != null ? this.scr.getComponentDescriptionDTOs(new Bundle[]{bundle}).toArray(new ComponentDescriptionDTO[0]) : null;
    }

    private List<ComponentDescriptionDTO> findComponents(String name) {
        String lowerName = name.toLowerCase();
        LinkedList<ComponentDescriptionDTO> matches = new LinkedList<ComponentDescriptionDTO>();
        for (ComponentDescriptionDTO dto : this.scr.getComponentDescriptionDTOs(new Bundle[0])) {
            if (dto.name.equalsIgnoreCase(name)) {
                return Collections.singletonList(dto);
            }
            if (!dto.name.toLowerCase().contains(lowerName)) continue;
            matches.add(dto);
        }
        return matches;
    }

    @Descriptor(value="Dump information of a component")
    public ComponentDescriptionDTO info(@Descriptor(value="Name of the component") String name) {
        List<ComponentDescriptionDTO> matches = this.findComponents(name);
        if (matches.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("No component description matching \"{0}\".", name));
        }
        if (matches.size() > 1) {
            StringBuilder partialMatchesStr = new StringBuilder();
            Iterator<ComponentDescriptionDTO> iter = matches.iterator();
            while (iter.hasNext()) {
                partialMatchesStr.append(iter.next().name);
                if (!iter.hasNext()) continue;
                partialMatchesStr.append(", ");
            }
            throw new IllegalArgumentException(MessageFormat.format("Multiple components matching \"{0}\": [{1}]", name, partialMatchesStr));
        }
        return matches.get(0);
    }

    @Descriptor(value="Dump information of a component configuration")
    public ComponentConfigurationDTO info(@Descriptor(value="ID of the component configuration") long id) {
        for (ComponentDescriptionDTO descDto : this.scr.getComponentDescriptionDTOs(new Bundle[0])) {
            for (ComponentConfigurationDTO configDto : this.scr.getComponentConfigurationDTOs(descDto)) {
                if (configDto.id != id) continue;
                return configDto;
            }
        }
        return null;
    }

    @Descriptor(value="Enable a disabled component")
    public boolean enable(@Descriptor(value="Name of the component") String name) {
        boolean changed = false;
        for (ComponentDescriptionDTO comp : this.findComponents(name)) {
            if (this.scr.isComponentEnabled(comp)) continue;
            this.scr.enableComponent(comp);
            changed = true;
        }
        return changed;
    }

    @Descriptor(value="Disable an enabled component")
    public boolean disable(@Descriptor(value="Name of the component") String name) {
        boolean changed = false;
        for (ComponentDescriptionDTO comp : this.findComponents(name)) {
            if (!this.scr.isComponentEnabled(comp)) continue;
            this.scr.disableComponent(comp);
            changed = true;
        }
        return changed;
    }

    @Descriptor(value="Show the current SCR configuration")
    public String config() {
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
        out.put("Log Level", this.scrConfig.getLogLevel().toString());
        out.put("Obsolete Component Factory with Factory Configuration", Boolean.toString(this.scrConfig.isFactoryEnabled()));
        out.put("Keep instances with no references", this.scrConfig.keepInstances() ? "Supported" : "Unsupported");
        out.put("Lock timeout ms", Long.toString(this.scrConfig.lockTimeout()));
        out.put("Stop timeout ms", Long.toString(this.scrConfig.stopTimeout()));
        out.put("Global extender", Boolean.toString(this.scrConfig.globalExtender()));
        out.put("Info Service registered", this.scrConfig.infoAsService() ? "Supported" : "Unsupported");
        StringBuilder builder = new StringBuilder();
        ComponentCommands.printColumnsAligned("SCR Configuration", out, '=', builder);
        return builder.toString();
    }

    public Object convert(Class<?> desiredType, Object in) throws Exception {
        return null;
    }

    public CharSequence format(Object target, int level) throws Exception {
        CharSequence result = target instanceof ComponentDescriptionDTO[] ? this.format((ComponentDescriptionDTO[])target, level) : (target instanceof ComponentDescriptionDTO ? this.format((ComponentDescriptionDTO)target, level) : (target instanceof ComponentConfigurationDTO ? this.format((ComponentConfigurationDTO)target, level) : null));
        return result;
    }

    CharSequence format(ComponentDescriptionDTO[] dtoArray, int level) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (dtoArray == null || dtoArray.length == 0) {
            sb.append("No component descriptions found");
        } else {
            int i = 0;
            while (i < dtoArray.length) {
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append(this.format(dtoArray[i], 1));
                ++i;
            }
        }
        return sb;
    }

    CharSequence format(ComponentDescriptionDTO dto, int level) throws Exception {
        List<ComponentConfigurationDTO> children;
        StringBuilder builder = new StringBuilder();
        Collection childrenTmp = this.scr.getComponentConfigurationDTOs(dto);
        if (childrenTmp == null) {
            children = Collections.emptyList();
        } else {
            children = new ArrayList(childrenTmp);
            Collections.sort(children, this.configDtoComparator);
        }
        switch (level) {
            case 1: {
                builder.append(MessageFormat.format("{0} in bundle {1} ({2}:{3}) {4}, {5,choice,0#0 instances|1#1 instance|1<{5} instances}.", dto.name, dto.bundle.id, dto.bundle.symbolicName, dto.bundle.version, dto.defaultEnabled ? "enabled" : "disabled", children.size()));
                for (ComponentConfigurationDTO child : children) {
                    builder.append("\n").append(INDENT_2).append(this.format(child, 1));
                }
                break;
            }
            case 0: {
                this.printComponentDescriptionAndConfigs(dto, children.toArray(new ComponentConfigurationDTO[0]), builder);
                break;
            }
        }
        return builder;
    }

    CharSequence format(ComponentConfigurationDTO dto, int level) throws Exception {
        StringBuilder builder = new StringBuilder();
        switch (level) {
            case 0: {
                this.printComponentDescriptionAndConfigs(dto.description, new ComponentConfigurationDTO[]{dto}, builder);
                break;
            }
            case 1: {
                builder.append("Id: ").append(dto.id);
                builder.append(", ").append("State:").append(ComponentCommands.stateToString(dto.state));
                Object[] pids = ComponentCommands.getStringArray(dto.properties, "service.pid", null);
                if (pids == null || pids.length <= 0) break;
                builder.append(", ").append("PID(s): ").append(Arrays.toString(pids));
                break;
            }
        }
        return builder;
    }

    void printComponentDescriptionAndConfigs(ComponentDescriptionDTO descDto, ComponentConfigurationDTO[] configs, StringBuilder builder) {
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
        out.put("Class", descDto.implementationClass);
        out.put("Bundle", String.format("%d (%s:%s)", descDto.bundle.id, descDto.bundle.symbolicName, descDto.bundle.version));
        out.put("Enabled", Boolean.toString(descDto.defaultEnabled));
        out.put("Immediate", Boolean.toString(descDto.immediate));
        out.put("Services", this.arrayToString(descDto.serviceInterfaces));
        if (descDto.scope != null) {
            out.put("Scope", descDto.scope);
        }
        out.put("Config PID(s)", String.format("%s, Policy: %s", this.arrayToString(descDto.configurationPid), descDto.configurationPolicy));
        out.put("Base Props", ComponentCommands.printProperties(descDto.properties, INDENT_1));
        if (descDto.factory != null) {
            out.put("Factory", descDto.factory);
            try {
                ServiceReference[] serviceRefs = this.context.getAllServiceReferences(ComponentFactory.class.getName(), String.format("(&(%s=%s)(%s=%d))", "component.name", descDto.name, "service.bundleid", descDto.bundle.id));
                if (serviceRefs != null && serviceRefs.length > 0) {
                    out.put("Factory Service", this.printPublishedServices(serviceRefs));
                }
            }
            catch (InvalidSyntaxException serviceRefs) {
                // empty catch block
            }
        }
        ComponentCommands.printColumnsAligned(String.format("Component Description: %s", descDto.name), out, '=', builder);
        if (configs != null) {
            ComponentConfigurationDTO[] componentConfigurationDTOArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentConfigurationDTO configDto = componentConfigurationDTOArray[n2];
                out.clear();
                builder.append("\n\n");
                String title = String.format("Component Configuration Id: %d", configDto.id);
                out.put("State", ComponentCommands.stateToString(configDto.state));
                try {
                    ServiceReference[] serviceRefs = this.context.getAllServiceReferences(null, String.format("(%s=%d)", "component.id", configDto.id));
                    if (serviceRefs != null && serviceRefs.length > 0) {
                        out.put("Service", this.printPublishedServices(serviceRefs));
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
                out.put("Config Props", ComponentCommands.printProperties(configDto.properties, INDENT_1));
                out.put("References", this.printServiceReferences(configDto.satisfiedReferences, configDto.unsatisfiedReferences, descDto.references));
                if (configDto.failure != null) {
                    out.put("Failure", configDto.failure);
                }
                ComponentCommands.printColumnsAligned(title, out, '-', builder);
                ++n2;
            }
        }
    }

    String printPublishedServices(ServiceReference<?>[] serviceRefs) {
        StringBuilder sb = new StringBuilder();
        if (serviceRefs.length > 1) {
            sb.append("(total ").append(serviceRefs.length).append(')');
            sb.append('\n').append(INDENT_1);
        }
        ServiceReference<?>[] serviceReferenceArray = serviceRefs;
        int n = serviceRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<?> serviceRef = serviceReferenceArray[n2];
            sb.append(serviceRef.getProperty("service.id"));
            sb.append(' ').append(Arrays.toString((String[])serviceRef.getProperty("objectClass")));
            Bundle[] consumers = serviceRef.getUsingBundles();
            if (consumers != null) {
                Bundle[] bundleArray = consumers;
                int n3 = consumers.length;
                int n4 = 0;
                while (n4 < n3) {
                    Bundle consumer = bundleArray[n4];
                    sb.append("\n").append(INDENT_2);
                    sb.append(String.format("Used by bundle %d (%s:%s)", consumer.getBundleId(), consumer.getSymbolicName(), consumer.getVersion()));
                    ++n4;
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    private String arrayToString(String[] array) {
        return array == null || array.length == 0 ? "<<none>>" : Arrays.toString(array);
    }

    static final String stateToString(int state) {
        String string;
        switch (state) {
            case 8: {
                string = "ACTIVE";
                break;
            }
            case 4: {
                string = "SATISFIED";
                break;
            }
            case 1: {
                string = "UNSATISFIED CONFIGURATION";
                break;
            }
            case 2: {
                string = "UNSATISFIED REFERENCE";
                break;
            }
            case 16: {
                string = "FAILED ACTIVATION";
                break;
            }
            default: {
                string = String.format("<<UNKNOWN: %d>>", state);
            }
        }
        return string;
    }

    static String printProperties(Map<String, ?> props, String indent) {
        StringBuilder builder = new StringBuilder();
        int size = props.size();
        builder.append('(').append(Integer.toString(size)).append(' ').append(size == 1 ? "entry" : "entries").append(')');
        if (size > 0) {
            TreeMap sortedMap = new TreeMap(props);
            for (Map.Entry e : sortedMap.entrySet()) {
                String typeName;
                String valueStr;
                builder.append('\n').append(indent);
                Object value = e.getValue();
                if (value == null) {
                    valueStr = "null";
                    typeName = "null";
                } else {
                    typeName = value.getClass().getSimpleName();
                    valueStr = value instanceof int[] ? Arrays.toString((int[])value) : (value instanceof long[] ? Arrays.toString((long[])value) : (value instanceof byte[] ? Arrays.toString((byte[])value) : (value instanceof short[] ? Arrays.toString((short[])value) : (value instanceof byte[] ? Arrays.toString((byte[])value) : (value instanceof char[] ? Arrays.toString((char[])value) : (value instanceof boolean[] ? Arrays.toString((boolean[])value) : (value instanceof float[] ? Arrays.toString((boolean[])value) : (value instanceof double[] ? Arrays.toString((boolean[])value) : (value instanceof Object[] ? Arrays.deepToString((Object[])value) : value.toString())))))))));
                }
                builder.append(String.format("%s<%s> = %s", e.getKey(), typeName, valueStr));
            }
        }
        return builder.toString();
    }

    String printServiceReferences(SatisfiedReferenceDTO[] satisfiedReferences, UnsatisfiedReferenceDTO[] unsatisfiedReferences, ReferenceDTO[] references) {
        UnsatisfiedReferenceDTO[] unsatisfiedReferenceDTOArray;
        int n;
        StringBuilder builder = new StringBuilder();
        HashMap<String, ReferenceDTO> refDtoMap = new HashMap<String, ReferenceDTO>();
        if (references != null) {
            ReferenceDTO[] referenceDTOArray = references;
            n = references.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceDTO refDto = referenceDTOArray[n2];
                refDtoMap.put(refDto.name, refDto);
                ++n2;
            }
        }
        int refCount = (satisfiedReferences != null ? satisfiedReferences.length : 0) + (unsatisfiedReferences != null ? unsatisfiedReferences.length : 0);
        builder.append("(total ").append(Integer.toString(refCount)).append(")");
        if (unsatisfiedReferences != null) {
            unsatisfiedReferenceDTOArray = unsatisfiedReferences;
            int n3 = unsatisfiedReferences.length;
            n = 0;
            while (n < n3) {
                UnsatisfiedReferenceDTO refDto = unsatisfiedReferenceDTOArray[n];
                this.printServiceReference((ReferenceDTO)refDtoMap.get(refDto.name), "UNSATISFIED", null, builder);
                ++n;
            }
        }
        if (satisfiedReferences != null) {
            unsatisfiedReferenceDTOArray = satisfiedReferences;
            int n4 = satisfiedReferences.length;
            n = 0;
            while (n < n4) {
                UnsatisfiedReferenceDTO refDto = unsatisfiedReferenceDTOArray[n];
                this.printServiceReference((ReferenceDTO)refDtoMap.get(refDto.name), "SATISFIED", refDto.boundServices != null ? refDto.boundServices : new ServiceReferenceDTO[]{}, builder);
                ++n;
            }
        }
        return builder.toString();
    }

    void printServiceReference(ReferenceDTO reference, String state, ServiceReferenceDTO[] bindings, StringBuilder builder) {
        StringBuilder policyWithOption = new StringBuilder().append(reference.policy);
        if (!"reluctant".equals(reference.policyOption)) {
            policyWithOption.append('+').append(reference.policyOption);
        }
        builder.append(String.format("%n  - %s: %s %s %s %s", reference.name, reference.interfaceName, state, reference.cardinality, policyWithOption));
        builder.append(String.format("%n    target=%s scope=%s", reference.target == null ? "(*)" : reference.target, reference.scope == null ? "bundle" : reference.scope));
        if (reference.collectionType != null) {
            builder.append(" collectionType=").append(reference.collectionType);
        }
        if (bindings != null) {
            Arrays.sort(bindings, this.serviceRefDtoComparator);
            builder.append(MessageFormat.format(" {0,choice,0#(no active bindings)|1#(1 binding):|1<({0} bindings):}", bindings.length));
            ServiceReferenceDTO[] serviceReferenceDTOArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReferenceDTO svcDto = serviceReferenceDTOArray[n2];
                Bundle provider = this.context.getBundle(svcDto.bundle);
                builder.append(String.format("%n    * Bound to [%d] from bundle %d (%s:%s)", svcDto.id, svcDto.bundle, provider.getSymbolicName(), provider.getVersion()));
                ++n2;
            }
        }
    }

    static void printColumnsAligned(String title, Map<String, String> properties, char underlineChar, StringBuilder builder) {
        builder.append(title);
        char[] carray = new char[title.length()];
        Arrays.fill(carray, underlineChar);
        builder.append('\n');
        builder.append(carray);
        int widestKey = 0;
        for (String string : properties.keySet()) {
            widestKey = Math.max(widestKey, string.length());
        }
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            int padLength = widestKey - key.length();
            char[] padding = new char[padLength];
            Arrays.fill(padding, ' ');
            builder.append('\n');
            builder.append(key).append(": ");
            builder.append(padding);
            builder.append((String)entry.getValue());
        }
    }

    private static String[] getStringArray(Map<String, ?> map, String name, String[] defaultValue) throws IllegalArgumentException {
        Object o = map.get(name);
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            if (c.isEmpty()) {
                return new String[0];
            }
            String[] a = new String[c.size()];
            Iterator iter = c.iterator();
            int i = 0;
            while (i < a.length) {
                Object elem = iter.next();
                if (!(elem instanceof String)) {
                    throw new IllegalArgumentException(String.format("Collection value for field '%s' contains non-String element at index %d.", name, i));
                }
                a[i] = (String)elem;
                ++i;
            }
            return a;
        }
        if (o == null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(String.format("Value for field '%s' is not a String, String-array or Collection of String. Actual type was %s.", name, o.getClass().getName()));
    }

    private void safeUnregister(ServiceRegistration<?> registration) {
        try {
            if (registration != null) {
                registration.unregister();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ServiceRegistration<?> addingService(ServiceReference<Object> reference) {
        Object converter;
        BundleRevision rev;
        Bundle b = reference.getBundle();
        BundleRevision bundleRevision = rev = b == null ? null : (BundleRevision)b.adapt(BundleRevision.class);
        if (rev != null && (converter = this.createConverter(b)) != null) {
            Hashtable<String, Object> svcProps = new Hashtable<String, Object>();
            ((Dictionary)svcProps).put("osgi.converter.classes", new String[]{ComponentDescriptionDTO.class.getName(), ComponentConfigurationDTO.class.getName()});
            ((Dictionary)svcProps).put("service.description", "SCR Runtime DTO Converter");
            ((Dictionary)svcProps).put("service.vendor", "The Apache Software Foundation");
            return b.getBundleContext().registerService("org.apache.felix.service.command.Converter", converter, svcProps);
        }
        return null;
    }

    private Object createConverter(Bundle bundle) {
        ClassLoader cl;
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null && (cl = wiring.getClassLoader()) != null) {
            try {
                Class[] types = new Class[]{cl.loadClass("org.apache.felix.service.command.Converter")};
                return Proxy.newProxyInstance(cl, types, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if ("convert".equals(method.getName())) {
                            return ComponentCommands.this.convert((Class)args[0], args[1]);
                        }
                        if ("format".equals(method.getName())) {
                            return ComponentCommands.this.format(args[0], (int)((Integer)args[1]));
                        }
                        return method.invoke((Object)this, args);
                    }
                });
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public void modifiedService(ServiceReference<Object> reference, ServiceRegistration<?> reg) {
    }

    public void removedService(ServiceReference<Object> reference, ServiceRegistration<?> reg) {
        this.safeUnregister(reg);
    }
}

